/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.concurrent.IActivityObserver;
import ch.systemsx.cisd.common.concurrent.InactivityMonitor;
import ch.systemsx.cisd.common.concurrent.RecordingActivityObserverSensor;
import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.StopException;
import ch.systemsx.cisd.common.exceptions.UnknownLastChangedException;
import ch.systemsx.cisd.common.exceptions.WrappedIOException;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.parser.filter.AlwaysAcceptLineFilter;
import ch.systemsx.cisd.common.parser.filter.ILineFilter;
import ch.systemsx.cisd.common.utilities.OSUtilities;
import ch.systemsx.cisd.common.utilities.StringUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DurationFormatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtilities {
    public static final FileFilter ACCEPT_ALL_FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return true;
        }
    };
    private static final Pattern ONE_OR_MORE_DIGITS = Pattern.compile(".*(\\d+)$");
    private static final NumberFormat SIZE_FORMAT = new DecimalFormat("0.00");

    private FileUtilities() {
    }

    public static void copyFileTo(File sourceFile, File destinationFile, boolean preservesLastModifiedDate) throws WrappedIOException {
        boolean successful;
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            try {
                inputStream = new FileInputStream(sourceFile);
                outputStream = new FileOutputStream(destinationFile);
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (IOException ex) {
                throw new EnvironmentFailureException("Couldn't copy file '" + sourceFile + "' to '" + destinationFile + "'.", ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
        if (preservesLastModifiedDate && !(successful = destinationFile.setLastModified(sourceFile.lastModified()))) {
            throw new EnvironmentFailureException("Couldn't copy last modified date of file '" + sourceFile + "' to '" + destinationFile + "' for some unknown reason.");
        }
    }

    public static String loadToString(File file) throws WrappedIOException {
        String string;
        assert (file != null);
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            string = FileUtilities.readString(new BufferedReader(fileReader));
        }
        catch (IOException ex) {
            try {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)fileReader);
        return string;
    }

    public static String loadExactToString(File file) throws WrappedIOException {
        String string;
        assert (file != null);
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            string = FileUtilities.readExactString(new BufferedReader(fileReader));
        }
        catch (IOException ex) {
            try {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)fileReader);
        return string;
    }

    public static void writeToFile(File file, String str) throws WrappedIOException {
        assert (file != null) : "Unspecified file.";
        assert (str != null) : "Unspecified string.";
        FileWriter fileWriter = null;
        try {
            try {
                fileWriter = new FileWriter(file);
                fileWriter.write(str);
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    public static final List<String> loadToStringList(File file) throws WrappedIOException {
        return FileUtilities.loadToStringList(file, null);
    }

    public static final List<String> loadToStringList(File file, ILineFilter lineFilterOrNull) throws WrappedIOException {
        List<String> list;
        assert (file != null) : "Unspecified file.";
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            list = FileUtilities.readStringList(new BufferedReader(fileReader), lineFilterOrNull);
        }
        catch (IOException ex) {
            try {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)fileReader);
        return list;
    }

    public static String loadToString(Class<?> clazz, String resource) throws WrappedIOException {
        assert (clazz != null) : "Given class can not be null.";
        assert (resource != null && resource.length() > 0) : "Given resource can not be null.";
        BufferedReader reader = null;
        try {
            reader = FileUtilities.tryGetBufferedReader(clazz, resource);
            String string = reader == null ? null : FileUtilities.readString(reader);
            return string;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static final List<String> loadToStringList(Class<?> clazz, String resource) throws WrappedIOException {
        return FileUtilities.loadToStringList(clazz, resource, null);
    }

    public static final List<String> loadToStringList(Class<?> clazz, String resource, ILineFilter lineFilterOrNull) throws WrappedIOException {
        assert (clazz != null) : "Given class can not be null.";
        assert (StringUtils.isNotEmpty((String)resource)) : "Given resource can not be empty.";
        BufferedReader reader = null;
        try {
            reader = FileUtilities.tryGetBufferedReader(clazz, resource);
            List<String> list = reader == null ? null : FileUtilities.readStringList(reader, lineFilterOrNull);
            return list;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    private static final BufferedReader tryGetBufferedReader(Class<?> clazz, String resource) {
        URL url = clazz.getResource(resource);
        if (url == null) {
            return null;
        }
        try {
            return new BufferedReader(new FileReader(new File(url.toURI())));
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
        catch (URISyntaxException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private static String readString(BufferedReader reader) throws IOException {
        String line;
        assert (reader != null) : "Unspecified BufferedReader.";
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line).append('\n');
        }
        return builder.toString();
    }

    private static String readExactString(BufferedReader reader) throws IOException {
        assert (reader != null) : "Unspecified BufferedReader.";
        StringBuilder builder = new StringBuilder();
        int numRead = 0;
        while ((numRead = reader.read()) != -1) {
            builder.append(String.copyValueOf(Character.toChars(numRead)));
        }
        reader.close();
        return builder.toString();
    }

    private static final List<String> readStringList(BufferedReader reader, ILineFilter lineFilterOrNull) throws IOException {
        assert (reader != null) : "Unspecified BufferedReader.";
        ILineFilter lineFilter = lineFilterOrNull == null ? AlwaysAcceptLineFilter.INSTANCE : lineFilterOrNull;
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        int lineNumber = 0;
        while (line != null) {
            if (lineFilter.acceptLine(line, lineNumber)) {
                list.add(line);
            }
            ++lineNumber;
            line = reader.readLine();
        }
        return list;
    }

    public static String checkPathFullyAccessible(File path, String kindOfPath) {
        assert (path != null);
        assert (kindOfPath != null);
        return FileUtilities.checkPathAccessible(path, kindOfPath, "path", true);
    }

    public static String checkPathReadAccessible(File path, String kindOfPath) {
        assert (path != null);
        assert (kindOfPath != null);
        return FileUtilities.checkPathAccessible(path, kindOfPath, "path", false);
    }

    public static String checkDirectoryReadAccessible(File directory, String kindOfDirectory) {
        assert (directory != null);
        assert (kindOfDirectory != null);
        String msg = FileUtilities.checkPathAccessible(directory, kindOfDirectory, "directory", false);
        if (msg == null && !directory.isDirectory()) {
            return String.format("Path '%s' is supposed to be a %s directory but isn't.", directory.getPath(), kindOfDirectory);
        }
        return msg;
    }

    public static String checkDirectoryFullyAccessible(File directory, String kindOfDirectory) {
        assert (directory != null);
        assert (kindOfDirectory != null);
        String msg = FileUtilities.checkPathAccessible(directory, kindOfDirectory, "directory", true);
        if (msg == null && !directory.isDirectory()) {
            return String.format("Path '%s' is supposed to be a %s directory but isn't.", directory.getPath(), kindOfDirectory);
        }
        return msg;
    }

    public static String checkFileReadAccessible(File file, String kindOfFile) {
        assert (file != null);
        assert (kindOfFile != null);
        String msg = FileUtilities.checkPathAccessible(file, kindOfFile, "directory", false);
        if (msg == null && !file.isFile()) {
            return String.format("Path '%s' is supposed to be a %s file but isn't.", file.getPath(), kindOfFile);
        }
        return msg;
    }

    public static String checkFileFullyAccessible(File file, String kindOfFile) {
        assert (file != null);
        assert (kindOfFile != null);
        String msg = FileUtilities.checkPathAccessible(file, kindOfFile, "file", true);
        if (msg == null && !file.isFile()) {
            return String.format("Path '%s' is supposed to be a %s file but isn't.", file.getPath(), kindOfFile);
        }
        return msg;
    }

    private static String checkPathAccessible(File path, String kindOfPath, String directoryOrFile, boolean readAndWrite) {
        assert (path != null);
        assert (kindOfPath != null);
        assert (directoryOrFile != null);
        if (!path.canRead()) {
            if (!path.exists()) {
                return String.format("%s %s '%s' does not exist.", StringUtilities.capitalize(kindOfPath), directoryOrFile, path.getPath());
            }
            return String.format("%s %s '%s' is not readable.", StringUtilities.capitalize(kindOfPath), directoryOrFile, path.getPath());
        }
        if (readAndWrite && !path.canWrite()) {
            return String.format("%s directory '%s' is not writable.", StringUtilities.capitalize(kindOfPath), path.getPath());
        }
        return null;
    }

    public static boolean deleteRecursively(File path) throws StopException {
        assert (path != null);
        return FileUtilities.deleteRecursively(path, null, null);
    }

    public static boolean deleteRecursively(File path, ISimpleLogger loggerOrNull) throws StopException {
        return FileUtilities.deleteRecursively(path, loggerOrNull, null);
    }

    public static boolean deleteRecursively(File path, ISimpleLogger loggerOrNull, IActivityObserver observerOrNull) throws StopException {
        assert (path != null);
        if (path.isDirectory()) {
            File[] fileArray = path.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (Thread.interrupted()) {
                    throw new StopException();
                }
                if (observerOrNull != null) {
                    observerOrNull.update();
                }
                if (file.isDirectory()) {
                    FileUtilities.deleteRecursively(file, loggerOrNull, observerOrNull);
                } else {
                    if (loggerOrNull != null) {
                        loggerOrNull.log(LogLevel.INFO, String.format("Deleting file '%s'", file.getPath()));
                    }
                    file.delete();
                }
                ++n2;
            }
        }
        if (loggerOrNull != null) {
            loggerOrNull.log(LogLevel.INFO, String.format("Deleting directory '%s'", path.getPath()));
        }
        return path.delete();
    }

    public static boolean deleteRecursively(File path, FileFilter filter, ISimpleLogger logger) throws StopException {
        assert (path != null);
        return FileUtilities.deleteRecursively(path, filter, logger, null);
    }

    public static boolean deleteRecursively(File path, FileFilter filter, ISimpleLogger logger, IActivityObserver observerOrNull) throws StopException {
        assert (path != null);
        assert (filter != null);
        if (filter.accept(path)) {
            return FileUtilities.deleteRecursively(path, logger, observerOrNull);
        }
        if (path.isDirectory()) {
            File[] fileArray = path.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (Thread.interrupted()) {
                    throw new StopException();
                }
                if (observerOrNull != null) {
                    observerOrNull.update();
                }
                FileUtilities.deleteRecursively(file, filter, logger, observerOrNull);
                ++n2;
            }
        }
        return false;
    }

    public static long lastChanged(File path, boolean subDirectoriesOnly, long stopWhenFindYounger) throws UnknownLastChangedException {
        return new LastChangedWorker(path, subDirectoriesOnly, stopWhenFindYounger, false).getLastChanged();
    }

    public static long lastChangedRelative(File path, boolean subDirectoriesOnly, long stopWhenFindYoungerRelative) throws UnknownLastChangedException {
        return new LastChangedWorker(path, subDirectoriesOnly, stopWhenFindYoungerRelative, true).getLastChanged();
    }

    public static long lastChanged(File path) throws UnknownLastChangedException {
        return FileUtilities.lastChanged(path, false, 0L);
    }

    public static final File removePrefixFromFileName(File file, String prefix) {
        assert (file != null);
        String name = file.getName();
        if (StringUtils.isEmpty((String)prefix)) {
            return file;
        }
        if (name.indexOf(prefix) < 0) {
            return file;
        }
        return new File(file.getParent(), name.substring(prefix.length()));
    }

    public static final File createNextNumberedFile(File path, Pattern regex) {
        return FileUtilities.createNextNumberedFile(path, regex, null);
    }

    public static final File createNextNumberedFile(File path, Pattern regexOrNull, String defaultFileNameOrNull) {
        Pattern pattern;
        assert (path != null);
        if (!path.exists()) {
            return path;
        }
        if (regexOrNull == null) {
            pattern = ONE_OR_MORE_DIGITS;
        } else {
            assert (regexOrNull.pattern().indexOf("(\\d+)") > -1 || regexOrNull.pattern().indexOf("([0-9]+)") > -1);
            pattern = regexOrNull;
        }
        String pathName = path.getName();
        Matcher matcher = pattern.matcher(pathName);
        boolean found = matcher.find();
        if (!found) {
            String fileName = !StringUtils.isEmpty((String)defaultFileNameOrNull) ? defaultFileNameOrNull : String.valueOf(pathName) + "1";
            return FileUtilities.createNextNumberedFile(new File(path.getParent(), fileName), pattern, defaultFileNameOrNull);
        }
        StringBuilder builder = new StringBuilder();
        int nextStart = 0;
        while (found) {
            String group = matcher.group(1);
            int newNumber = Integer.parseInt(group) + 1;
            builder.append(pathName.substring(nextStart, matcher.start(1))).append(newNumber);
            nextStart = matcher.end(1);
            found = matcher.find();
        }
        builder.append(pathName.substring(nextStart));
        File newFile = new File(path.getParent(), builder.toString());
        if (newFile.exists()) {
            return FileUtilities.createNextNumberedFile(newFile, pattern, defaultFileNameOrNull);
        }
        return newFile;
    }

    public static final String getRelativeFile(File root, File file) {
        assert (root != null) : "Given root can not be null.";
        assert (file != null) : "Given file can not be null.";
        String rootPath = String.valueOf(root.getAbsolutePath()) + File.separator;
        String filePath = file.getAbsolutePath();
        if (filePath.startsWith(rootPath)) {
            return filePath.substring(rootPath.length());
        }
        return null;
    }

    public static File[] tryListFiles(File directory, ISimpleLogger loggerOrNull) {
        return FileUtilities.tryListFiles(directory, ACCEPT_ALL_FILTER, loggerOrNull);
    }

    public static File[] tryListFiles(File directory, FileFilter filter, ISimpleLogger loggerOrNull) {
        File[] paths = null;
        RuntimeException ex = null;
        try {
            paths = directory.listFiles(filter);
        }
        catch (RuntimeException e) {
            ex = e;
        }
        if (paths == null && loggerOrNull != null) {
            FileUtilities.logFailureInDirectoryListing(ex, directory, loggerOrNull);
        }
        return paths;
    }

    public static final void sortByLastModified(File[] files) {
        Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
    }

    private static void logFailureInDirectoryListing(RuntimeException exOrNull, File directory, ISimpleLogger logger) {
        if (exOrNull == null) {
            if (directory.isFile()) {
                logger.log(LogLevel.ERROR, String.format("Failed to get listing of directory '%s' (path is file instead of directory).", directory));
            } else {
                logger.log(LogLevel.ERROR, String.format("Failed to get listing of directory '%s' (path not found).", directory));
            }
        } else {
            StringWriter exStackWriter = new StringWriter();
            exOrNull.printStackTrace(new PrintWriter(exStackWriter));
            logger.log(LogLevel.ERROR, String.format("Failed to get listing of directory '%s'. Exception: %s", directory, exStackWriter.toString()));
        }
    }

    public static final String copyResourceToTempFile(String resource, String prefix, String postfix) throws WrappedIOException {
        InputStream resourceStream = FileUtilities.class.getResourceAsStream(resource);
        if (resourceStream == null) {
            throw new IllegalArgumentException("Resource '" + resource + "' not found.");
        }
        try {
            File tempFile = File.createTempFile(prefix, postfix);
            tempFile.deleteOnExit();
            FileOutputStream fileStream = new FileOutputStream(tempFile);
            try {
                IOUtils.copy((InputStream)resourceStream, (OutputStream)fileStream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)fileStream);
            }
            String string = tempFile.getAbsolutePath();
            return string;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)resourceStream);
        }
    }

    public static final String tryCopyNativeLibraryToTempFile(String libraryName) {
        return FileUtilities.tryCopyResourceToTempFile(String.format("/native/%s/%s/%s.so", libraryName, OSUtilities.getCompatibleComputerPlatform(), libraryName), libraryName, ".so");
    }

    public static final boolean loadNativeLibraryFromResource(String libraryName) {
        File linkLib;
        String filename = FileUtilities.tryCopyNativeLibraryToTempFile(libraryName);
        if (filename != null && (linkLib = new File(filename)).exists() && linkLib.canRead() && linkLib.isFile()) {
            try {
                System.load(filename);
                return true;
            }
            catch (Throwable err) {
                System.err.printf("Native library '%s' failed to load:\n", filename);
                err.printStackTrace();
            }
        }
        return false;
    }

    public static final String tryCopyResourceToTempFile(String resource, String prefix, String postfix) {
        try {
            return FileUtilities.copyResourceToTempFile(resource, prefix, postfix);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final File[] listFiles(File directory) throws EnvironmentFailureException {
        File[] fileList = directory.listFiles();
        if (fileList == null) {
            throw EnvironmentFailureException.fromTemplate("Failed to get listing of directory '%s'", directory.getAbsolutePath());
        }
        return fileList;
    }

    public static List<File> listFiles(File directory, String[] extensionsOrNull, boolean recursive, IActivityObserver observerOrNull) {
        assert (directory != null);
        LinkedList<File> result = new LinkedList<File>();
        FileUtilities.internalListFiles(directory, result, new ExtensionFileFilter(extensionsOrNull, recursive, observerOrNull), observerOrNull, recursive, FType.FILE);
        return result;
    }

    public static List<File> listDirectories(File directory, boolean recursive, IActivityObserver observerOrNull) {
        assert (directory != null);
        LinkedList<File> result = new LinkedList<File>();
        FileUtilities.internalListFiles(directory, result, new DirectoryFilter(observerOrNull), observerOrNull, recursive, FType.DIRECTORY);
        return result;
    }

    public static List<File> listFilesAndDirectories(File directory, boolean recursive, IActivityObserver observerOrNull) {
        assert (directory != null);
        LinkedList<File> result = new LinkedList<File>();
        FileUtilities.internalListFiles(directory, result, new TrueFilter(observerOrNull), observerOrNull, recursive, FType.EITHER);
        return result;
    }

    private static void internalListFiles(File directory, List<File> result, FileFilter filter, IActivityObserver observerOrNull, boolean recursive, FType ftype) {
        File[] filteredFilesAndDirectories = directory.listFiles(filter);
        if (filteredFilesAndDirectories == null) {
            return;
        }
        File[] fileArray = filteredFilesAndDirectories;
        int n = filteredFilesAndDirectories.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (observerOrNull != null) {
                observerOrNull.update();
            }
            if (f.isDirectory()) {
                if (ftype != FType.FILE) {
                    result.add(f);
                }
                if (recursive) {
                    FileUtilities.internalListFiles(f, result, filter, observerOrNull, recursive, ftype);
                }
            } else if (ftype != FType.DIRECTORY) {
                result.add(f);
            }
            ++n2;
        }
    }

    public static final File normalizeFile(File file) {
        assert (file != null) : "Given file can not be null.";
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return new File(FilenameUtils.normalize((String)file.getAbsolutePath()));
        }
    }

    public static final String getCanonicalPath(File file) {
        assert (file != null) : "Given file can not be null.";
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static final String byteCountToDisplaySize(long size) {
        assert (size > -1L) : "Negative size value";
        String displaySize = size / 0x40000000L > 0L ? String.valueOf(SIZE_FORMAT.format((float)size / 1.0737418E9f)) + " GB" : (size / 0x100000L > 0L ? String.valueOf(SIZE_FORMAT.format((float)size / 1048576.0f)) + " MB" : (size / 1024L > 0L ? String.valueOf(SIZE_FORMAT.format((float)size / 1024.0f)) + " KB" : String.valueOf(SIZE_FORMAT.format(size)) + " bytes"));
        return displaySize;
    }

    public static class DeleteActivityDetector
    extends RecordingActivityObserverSensor
    implements InactivityMonitor.IDescribingActivitySensor {
        private final File path;

        public DeleteActivityDetector(File path) {
            this.path = path;
        }

        public String describeInactivity(long now) {
            return "No delete activity of path " + this.path.getPath() + " for " + DurationFormatUtils.formatDurationHMS((long)(now - this.getLastActivityMillis()));
        }
    }

    private static final class DirectoryFilter
    implements FileFilter {
        private final IActivityObserver observerOrNull;

        DirectoryFilter(IActivityObserver observerOrNull) {
            this.observerOrNull = observerOrNull;
        }

        public boolean accept(File pathname) {
            if (this.observerOrNull != null) {
                this.observerOrNull.update();
            }
            return pathname.isDirectory();
        }
    }

    private static final class ExtensionFileFilter
    implements FileFilter {
        private final String[] extensionsOrNull;
        private final IActivityObserver observerOrNull;
        private final boolean recursive;

        ExtensionFileFilter(String[] extensionsOrNull, boolean recursive, IActivityObserver observerOrNull) {
            this.extensionsOrNull = extensionsOrNull;
            this.recursive = recursive;
            this.observerOrNull = observerOrNull;
        }

        private boolean correctType(File file) {
            return this.recursive || file.isFile();
        }

        private boolean match(String extensionFound) {
            if (this.extensionsOrNull == null) {
                return true;
            }
            if (extensionFound.length() == 0) {
                return false;
            }
            String[] stringArray = this.extensionsOrNull;
            int n = this.extensionsOrNull.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                if (extensionFound.equals(ext)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public boolean accept(File file) {
            if (this.observerOrNull != null) {
                this.observerOrNull.update();
            }
            if (this.recursive && file.isDirectory()) {
                return true;
            }
            return this.correctType(file) && this.match(FilenameUtils.getExtension((String)file.getName()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FType {
        FILE,
        DIRECTORY,
        EITHER;

    }

    private static final class LastChangedWorker {
        private final boolean subDirectoriesOnly;
        private final long reference;
        private final boolean referenceIsRelative;
        private long lastChanged;
        private boolean terminated;

        LastChangedWorker(File root, boolean subDirectoriesOnly, long reference, boolean referenceIsRelative) throws UnknownLastChangedException {
            assert (root != null);
            this.subDirectoriesOnly = subDirectoriesOnly;
            this.reference = reference;
            this.referenceIsRelative = referenceIsRelative;
            this.terminated = false;
            this.lastChanged = 0L;
            this.updateLastChanged(root);
            if (!this.terminated) {
                this.traverse(root);
            }
        }

        private void updateLastChanged(File path) throws UnknownLastChangedException {
            assert (path != null);
            long lastModified = path.lastModified();
            if (lastModified == 0L) {
                throw new UnknownLastChangedException(String.format("Cannot get the last modification date of '%s'.", path.getPath()));
            }
            this.lastChanged = Math.max(lastModified, this.lastChanged);
            if (this.isYoungEnough(this.lastChanged)) {
                this.terminated = true;
            }
        }

        private boolean isYoungEnough(long currentLastChanged) {
            if (this.referenceIsRelative) {
                return this.reference > 0L && currentLastChanged > System.currentTimeMillis() - this.reference;
            }
            return this.reference > 0L && currentLastChanged > this.reference;
        }

        private void traverse(File path) throws UnknownLastChangedException {
            assert (path != null);
            if (!path.isDirectory()) {
                return;
            }
            File[] fileArray = this.getEntries(path);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File entry = fileArray[n2];
                this.updateLastChanged(entry);
                if (this.terminated) {
                    return;
                }
                StopException.check();
                this.traverse(entry);
                ++n2;
            }
        }

        private File[] getEntries(File directory) {
            assert (directory != null);
            if (this.subDirectoriesOnly) {
                return directory.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                });
            }
            return directory.listFiles();
        }

        long getLastChanged() {
            return this.lastChanged;
        }
    }

    private static final class TrueFilter
    implements FileFilter {
        private final IActivityObserver observerOrNull;

        TrueFilter(IActivityObserver observerOrNull) {
            this.observerOrNull = observerOrNull;
        }

        public boolean accept(File pathname) {
            if (this.observerOrNull != null) {
                this.observerOrNull.update();
            }
            return true;
        }
    }
}

