/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.exceptions.StopException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.IFileImmutableCopier;
import ch.systemsx.cisd.common.utilities.IImmutableCopier;
import java.io.File;
import org.apache.log4j.Logger;

public final class RecursiveHardLinkMaker
implements IImmutableCopier {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, RecursiveHardLinkMaker.class);
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, RecursiveHardLinkMaker.class);
    private final IFileImmutableCopier fileCopier;

    private RecursiveHardLinkMaker(IFileImmutableCopier fileCopier) {
        this.fileCopier = fileCopier;
    }

    public static IImmutableCopier tryCreate(IFileImmutableCopier fileCopierOrNull) {
        if (fileCopierOrNull == null) {
            return null;
        }
        return new RecursiveHardLinkMaker(fileCopierOrNull);
    }

    public boolean copyImmutably(File source, File destinationDirectory, String nameOrNull) {
        assert (source != null && source.exists());
        assert (destinationDirectory != null && destinationDirectory.isDirectory());
        String destName = nameOrNull == null ? source.getName() : nameOrNull;
        File destFile = new File(destinationDirectory, destName);
        if (destFile.exists()) {
            operationLog.error(String.format("File '%s' already exists in given destination directory '%s'", destName, destinationDirectory));
            return false;
        }
        if (operationLog.isTraceEnabled()) {
            operationLog.trace(String.format("Creating a hard link copy of '%s' in '%s'.", source.getPath(), destinationDirectory.getPath()));
        }
        return this.primCopyImmutably(source, destinationDirectory, nameOrNull);
    }

    private final boolean primCopyImmutably(File source, File destinationDirectory, String nameOrNull) {
        if (source.isFile()) {
            return this.fileCopier.copyFileImmutably(source, destinationDirectory, nameOrNull);
        }
        String name = nameOrNull == null ? source.getName() : nameOrNull;
        File dir = RecursiveHardLinkMaker.tryCreateDir(name, destinationDirectory);
        if (dir == null) {
            return false;
        }
        File[] files = source.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                StopException.check();
                if (!this.primCopyImmutably(file, dir, null)) {
                    return false;
                }
                ++n2;
            }
        } else if (!source.exists()) {
            operationLog.error(String.format("Path '%s' vanished during processing.", source));
        } else {
            operationLog.error(String.format("Found path '%s' that is neither a file nor a directory.", source));
        }
        return true;
    }

    private static final File tryCreateDir(String name, File destDir) {
        File dir = new File(destDir, name);
        boolean ok = dir.mkdir();
        if (!ok) {
            if (dir.isDirectory()) {
                machineLog.error(String.format("Directory %s already exists in %s", name, destDir.getAbsolutePath()));
                ok = true;
            } else {
                machineLog.error(String.format("Could not create directory %s inside %s.", name, destDir.getAbsolutePath()));
                if (dir.isFile()) {
                    machineLog.error("There is a file with a same name.");
                }
            }
        }
        return ok ? dir : null;
    }
}

