/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.concurrent.InactivityMonitor;
import ch.systemsx.cisd.common.exceptions.UnknownLastChangedException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import java.io.File;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.log4j.Logger;

public class RemoteDirectoryCopyActivitySensor
implements InactivityMonitor.IDescribingActivitySensor {
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, RemoteDirectoryCopyActivitySensor.class);
    private static final int DEFAULT_MAX_ERRORS_TO_IGNORE = 3;
    private final int maxErrorsToIgnore;
    private final File destination;
    private final long timeOfCreation;
    private long timeOfLastConfirmedActivity;
    private long timeOfLastReportedActivity;
    private long lastNonErrorResult;
    private Long currentResult;
    private int errorCount;

    public RemoteDirectoryCopyActivitySensor(File destination) {
        this(destination, 3);
    }

    public RemoteDirectoryCopyActivitySensor(File destination, int maxErrorsToIgnore) {
        this.timeOfLastConfirmedActivity = this.timeOfCreation = System.currentTimeMillis();
        this.timeOfLastReportedActivity = this.timeOfCreation;
        this.lastNonErrorResult = -1L;
        this.errorCount = 0;
        this.destination = destination;
        this.maxErrorsToIgnore = maxErrorsToIgnore;
        this.currentResult = null;
    }

    public long getLastActivityMillisMoreRecentThan(long thresholdMillis) {
        try {
            this.currentResult = FileUtilities.lastChangedRelative(this.destination, true, thresholdMillis);
        }
        catch (UnknownLastChangedException unknownLastChangedException) {
            this.currentResult = null;
        }
        long now = System.currentTimeMillis();
        if (this.currentResult == null) {
            ++this.errorCount;
            if (this.errorCount <= this.maxErrorsToIgnore) {
                this.timeOfLastReportedActivity = now;
                machineLog.error(String.valueOf(this.describeInactivity(now)) + String.format(" (error count: %d <= %d, goes unreported)", this.errorCount, this.maxErrorsToIgnore));
            } else {
                machineLog.error(String.valueOf(this.describeInactivity(now)) + String.format(" (error count: %s, reported to monitor)", this.errorCount));
            }
        } else {
            if (this.currentResult != this.lastNonErrorResult) {
                this.timeOfLastConfirmedActivity = now;
                this.lastNonErrorResult = this.currentResult;
                if (machineLog.isDebugEnabled()) {
                    machineLog.debug(String.format("Observing write activity on target '%s'", this.destination));
                }
            }
            this.timeOfLastReportedActivity = this.timeOfLastConfirmedActivity;
            this.errorCount = 0;
        }
        return this.timeOfLastReportedActivity;
    }

    public boolean hasActivityMoreRecentThan(long thresholdMillis) {
        long now = System.currentTimeMillis();
        return now - this.getLastActivityMillisMoreRecentThan(thresholdMillis) < thresholdMillis;
    }

    public String describeInactivity(long now) {
        if (this.currentResult == null) {
            return String.format("Error: Unable to determine the time of write activity on target '%s'", this.destination);
        }
        String inactivityPeriod = DurationFormatUtils.formatDurationHMS((long)(now - this.timeOfLastConfirmedActivity));
        return String.format("No write activity on target '%s' for %s", this.destination, inactivityPeriod);
    }
}

