/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.StopException;
import ch.systemsx.cisd.common.filesystem.QueueingPathRemoverService;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.common.utilities.IImmutableCopier;
import ch.systemsx.cisd.etlserver.IFile;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class FileBasedFile
implements IFile {
    private final IImmutableCopier hardLinkCopierOrNull;
    private final File file;

    public FileBasedFile(File file, IImmutableCopier hardLinkCopierOrNull) {
        assert (file != null) : "Unspecified file.";
        this.file = file;
        this.hardLinkCopierOrNull = hardLinkCopierOrNull;
    }

    public void copyFrom(File sourceFile) {
        this.copy(sourceFile, this.file);
    }

    public void copyTo(File destinationFile) {
        this.copy(this.file, destinationFile);
    }

    private void copy(File sourceFile, File destinationFile) {
        if (sourceFile.isDirectory()) {
            this.copyDirectory(sourceFile, destinationFile);
        } else {
            this.copyFile(sourceFile, destinationFile);
        }
    }

    private void copyFile(File sourceFile, File destinationFile) {
        if (this.hardLinkCopierOrNull != null) {
            File destinationDirectory = destinationFile.getParentFile();
            boolean ok = this.hardLinkCopierOrNull.copyImmutably(sourceFile, destinationDirectory, destinationFile.getName());
            if (!ok) {
                throw new EnvironmentFailureException("Couldn't copy '" + sourceFile.getAbsolutePath() + "' using hard links to '" + destinationFile.getAbsolutePath() + "'. Maybe the destination already exists?");
            }
        } else {
            try {
                StopException.check();
                FileUtils.copyFile((File)sourceFile, (File)destinationFile, (boolean)true);
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    private void copyDirectory(File sourceDirectory, File destinationDirectory) {
        if (this.hardLinkCopierOrNull != null) {
            File destinationParentDirectory = destinationDirectory.getParentFile();
            boolean ok = this.hardLinkCopierOrNull.copyImmutably(sourceDirectory, destinationParentDirectory, destinationDirectory.getName());
            if (!ok) {
                throw new EnvironmentFailureException("Couldn't copy '" + sourceDirectory.getAbsolutePath() + "' using hard links to '" + destinationDirectory.getAbsolutePath() + "'. Maybe the destination already exists?");
            }
        } else {
            try {
                StopException.check();
                FileUtils.copyDirectory((File)sourceDirectory, (File)destinationDirectory, (boolean)true);
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    public void delete() {
        if (!QueueingPathRemoverService.getInstance().removeRecursively(this.file)) {
            throw new EnvironmentFailureException("Couldn't delete file '" + this.file.getAbsolutePath() + "'.");
        }
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public byte[] read() {
        try {
            return FileUtils.readFileToByteArray((File)this.file);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public void write(byte[] data) {
        try {
            FileUtils.writeByteArrayToFile((File)this.file, (byte[])data);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public final void check() throws EnvironmentFailureException, ConfigurationFailureException {
        String response = FileUtilities.checkDirectoryFullyAccessible(this.file, "");
        if (response != null) {
            throw new ConfigurationFailureException(response);
        }
    }

    public boolean canReadAndWrite() {
        return this.file.canRead() && this.file.canWrite();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }
}

