/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.bds.hcs.Geometry;
import ch.systemsx.cisd.bds.hcs.Location;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HCSImageCheckList {
    private final List<Map<Location, Map<Location, Check>>> list;

    HCSImageCheckList(int numberOfChannels, Geometry plateGeometry, Geometry wellGeometry) {
        if (numberOfChannels < 1) {
            throw new IllegalArgumentException("Number of channels smaller than one.");
        }
        if (plateGeometry == null) {
            throw new IllegalArgumentException("Unspecified plate geometry.");
        }
        if (wellGeometry == null) {
            throw new IllegalArgumentException("Unspecified well geometry.");
        }
        this.list = new ArrayList<Map<Location, Map<Location, Check>>>(numberOfChannels);
        int i = 0;
        while (i < numberOfChannels) {
            LinkedHashMap<Location, Map<Location, Check>> map = new LinkedHashMap<Location, Map<Location, Check>>();
            int x = 1;
            while (x <= plateGeometry.getColumns()) {
                int y = 1;
                while (y <= plateGeometry.getRows()) {
                    map.put(new Location(x, y), this.createTiles(wellGeometry));
                    ++y;
                }
                ++x;
            }
            this.list.add(map);
            ++i;
        }
    }

    private final Map<Location, Check> createTiles(Geometry wellGeometry) {
        LinkedHashMap<Location, Check> tiles = new LinkedHashMap<Location, Check>();
        int x = 1;
        while (x <= wellGeometry.getColumns()) {
            int y = 1;
            while (y <= wellGeometry.getRows()) {
                tiles.put(new Location(x, y), new Check());
                ++y;
            }
            ++x;
        }
        return tiles;
    }

    final void checkOff(int channel, Location wellLocation, Location tileLocation) {
        assert (wellLocation != null) : "Unspecified well location.";
        assert (tileLocation != null) : "Unspecified tile location.";
        if (channel < 1) {
            throw new IllegalArgumentException("Not a positive channel number: " + channel);
        }
        if (channel > this.list.size()) {
            throw new IllegalArgumentException("Channel number to large: " + channel + " > " + this.list.size());
        }
        Map<Location, Map<Location, Check>> map = this.list.get(channel - 1);
        Map<Location, Check> tiles = map.get(wellLocation);
        if (tiles == null) {
            throw new IllegalArgumentException("Invalid well location: " + wellLocation);
        }
        Check check = tiles.get(tileLocation);
        if (check == null) {
            throw new IllegalArgumentException("Invalid tile location: " + tileLocation);
        }
        if (check.isCheckedOff()) {
            throw new IllegalArgumentException("Image already handle for channel" + channel + ", well:" + wellLocation + " tile:" + tileLocation);
        }
        check.checkOff();
    }

    final int getNumberOfMissingCheckOffs() {
        int sum = 0;
        for (Map<Location, Map<Location, Check>> map : this.list) {
            for (Map<Location, Check> wells : map.values()) {
                for (Check check : wells.values()) {
                    if (check.isCheckedOff()) continue;
                    ++sum;
                }
            }
        }
        return sum;
    }

    private static final class Check {
        private boolean checkedOff;

        private Check() {
        }

        final void checkOff() {
            this.checkedOff = true;
        }

        final boolean isCheckedOff() {
            return this.checkedOff;
        }
    }
}

