/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.etlserver.DataSetInformation;
import ch.systemsx.cisd.etlserver.DataStoreStrategyKey;
import ch.systemsx.cisd.etlserver.IDataStoreStrategy;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ObservableType;
import java.io.File;

class IdentifiedDataStrategy
implements IDataStoreStrategy {
    private static final String DATA_SET_PREFIX = "Dataset_";
    static final String UNEXPECTED_PATHS_MSG_FORMAT = "There are unexpected paths '%s' in data store '%s'. I'll proceed anyway.";
    static final String STORAGE_LAYOUT_ERROR_MSG_PREFIX = "Serious error in data store layout: ";

    IdentifiedDataStrategy() {
    }

    private static String createInstanceDirectory(DataSetInformation dataSetInfo) {
        String instanceCode = dataSetInfo.getInstanceCode();
        assert (instanceCode != null) : "Instance code can not be null.";
        return "Instance_" + instanceCode;
    }

    private static String createGroupDirectory(DataSetInformation dataSetInfo) {
        ExperimentIdentifier identifier = dataSetInfo.getExperimentIdentifier();
        assert (identifier != null) : "Identifier can not be null.";
        String groupCode = identifier.getGroupCode();
        assert (groupCode != null) : "Group code can not be null.";
        return "Group_" + groupCode;
    }

    private static String createProjectDirectory(DataSetInformation dataSetInfo) {
        ExperimentIdentifier identifier = dataSetInfo.getExperimentIdentifier();
        assert (identifier != null) : "Identifier can not be null.";
        String projectCode = identifier.getProjectCode();
        assert (projectCode != null) : "Project code can not be null.";
        return "Project_" + projectCode;
    }

    private static String createExperimentDirectory(DataSetInformation dataSetInfo) {
        ExperimentIdentifier identifier = dataSetInfo.getExperimentIdentifier();
        assert (identifier != null) : "Identifier can not be null.";
        String experimentCode = identifier.getExperimentCode();
        assert (experimentCode != null) : "Experiment code can not be null.";
        return "Experiment_" + experimentCode;
    }

    private static final String createBarcodeDirectory(DataSetInformation dataSetInfo) {
        String sampleCode = dataSetInfo.getSampleCode();
        assert (sampleCode != null) : "Sample code can not be null.";
        return "Sample_" + sampleCode;
    }

    static final String createObservableTypeDirectory(ObservableType observableType) {
        String observableTypeCode = observableType.getCode();
        assert (observableTypeCode != null) : "Observable type code can not be null.";
        return "ObservableType_" + observableTypeCode;
    }

    private static final File createBaseDirectory(File baseDir, DataSetInformation dataSetInfo, ObservableType observableType) {
        File instanceDir = new File(baseDir, IdentifiedDataStrategy.createInstanceDirectory(dataSetInfo));
        File groupDir = new File(instanceDir, IdentifiedDataStrategy.createGroupDirectory(dataSetInfo));
        File projectDir = new File(groupDir, IdentifiedDataStrategy.createProjectDirectory(dataSetInfo));
        File experimentDir = new File(projectDir, IdentifiedDataStrategy.createExperimentDirectory(dataSetInfo));
        File observableTypeDir = new File(experimentDir, IdentifiedDataStrategy.createObservableTypeDirectory(observableType));
        return new File(observableTypeDir, IdentifiedDataStrategy.createBarcodeDirectory(dataSetInfo));
    }

    public final DataStoreStrategyKey getKey() {
        return DataStoreStrategyKey.IDENTIFIED;
    }

    public final File getBaseDirectory(File storeRoot, DataSetInformation dataSetInfo, ObservableType observableType) {
        assert (storeRoot != null) : "Store root can not be null";
        assert (dataSetInfo != null) : "Data set information can not be null";
        assert (observableType != null) : "Observable type can not be null";
        File baseDirectory = IdentifiedDataStrategy.createBaseDirectory(storeRoot, dataSetInfo, observableType);
        assert (dataSetInfo.getDataSetCode() != null) : "No data set code available";
        File dataSetBaseDirectory = new File(baseDirectory, DATA_SET_PREFIX + dataSetInfo.getDataSetCode());
        if (baseDirectory.isFile()) {
            throw EnvironmentFailureException.fromTemplate("Serious error in data store layout: Base directory '%s' is a file.", baseDirectory);
        }
        if (dataSetBaseDirectory.exists()) {
            throw EnvironmentFailureException.fromTemplate("Serious error in data store layout: Data set directory '%s' exists but has been designed to be unique.", dataSetBaseDirectory.getPath());
        }
        return dataSetBaseDirectory;
    }

    public final File getTargetPath(File baseDirectory, File incomingDataSetPath) throws IllegalStateException {
        assert (baseDirectory != null) : "Base directory can not be null";
        assert (incomingDataSetPath != null) : "Incoming data set can not be null";
        File targetPath = new File(baseDirectory, incomingDataSetPath.getName());
        if (targetPath.exists()) {
            throw new IllegalStateException(String.format("Target path '%s' of identified incoming data set already exists (which it shouldn't), bailing out.", targetPath.getAbsolutePath()));
        }
        return targetPath;
    }
}

