/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.TimingParameters;
import ch.systemsx.cisd.common.concurrent.TimerUtilities;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.common.exceptions.StopException;
import ch.systemsx.cisd.common.filesystem.QueueingPathRemoverService;
import ch.systemsx.cisd.common.highwatermark.CachingFreeDiskspaceProvider;
import ch.systemsx.cisd.common.highwatermark.HighwaterMarkGuard;
import ch.systemsx.cisd.common.highwatermark.IFreeDiskspaceProvider;
import ch.systemsx.cisd.common.highwatermark.LocalFreeDiskspaceProvider;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.utilities.BuildAndEnvironmentInfo;
import ch.systemsx.cisd.common.utilities.DirectoryScanningTimerTask;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.ISelfTestable;
import ch.systemsx.cisd.common.utilities.NamePrefixFileFilter;
import ch.systemsx.cisd.common.utilities.PropertyUtils;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.etlserver.EncapsulatedLimsService;
import ch.systemsx.cisd.etlserver.IETLServerPlugin;
import ch.systemsx.cisd.etlserver.IEncapsulatedLimsService;
import ch.systemsx.cisd.etlserver.IProcessorFactory;
import ch.systemsx.cisd.etlserver.Parameters;
import ch.systemsx.cisd.etlserver.StandardProcessorFactory;
import ch.systemsx.cisd.etlserver.ThreadParameters;
import ch.systemsx.cisd.etlserver.TransferredDataSetHandler;
import ch.systemsx.cisd.lims.base.IETLLIMSService;
import ch.systemsx.cisd.lims.base.RMIBasedLIMSServiceFactory;
import ch.systemsx.cisd.lims.base.ServiceRegistry;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Main {
    static final String INSTANCE_CODE_KEY = "instance-code";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, Main.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, Main.class);
    private static final File shredderQueueFile = new File(".shredder");
    private static final Thread.UncaughtExceptionHandler loggingExceptionHandler = new Thread.UncaughtExceptionHandler(){

        public void uncaughtException(Thread t, Throwable e) {
            notificationLog.error("An exception has occurred [thread: '" + t.getName() + "'].", e);
        }
    };
    static IExitHandler exitHandler = SystemExit.SYSTEM_EXIT;

    private static void initLog() {
        LogInitializer.init();
        Thread.setDefaultUncaughtExceptionHandler(loggingExceptionHandler);
    }

    private static void printInitialLogMessage(Parameters parameters) {
        operationLog.info("Etlserver is starting up.");
        for (String line : BuildAndEnvironmentInfo.INSTANCE.getEnvironmentInfo()) {
            operationLog.info(line);
        }
        parameters.log();
    }

    private static boolean checkListShredder(String[] args) {
        if (args.length > 0 && args[0].equals("--show-shredder")) {
            List<File> shredderItems = QueueingPathRemoverService.listShredderItems(shredderQueueFile);
            if (shredderItems.isEmpty()) {
                System.out.println("Shredder is empty.");
            } else {
                System.out.println("Found " + shredderItems.size() + " items in shredder:");
                for (File f : shredderItems) {
                    System.out.println(f.getAbsolutePath());
                }
            }
            return true;
        }
        return false;
    }

    private static void selfTest(File incomingDirectory, IEncapsulatedLimsService service, ISelfTestable ... selfTestables) {
        try {
            Main.checkFullyAccessible(incomingDirectory);
            int serviceVersion = service.getVersion();
            if (18 != serviceVersion) {
                throw new ConfigurationFailureException("This client has the wrong service version for the server (client: 18, server: " + serviceVersion + ").");
            }
            ISelfTestable[] iSelfTestableArray = selfTestables;
            int n = selfTestables.length;
            int n2 = 0;
            while (n2 < n) {
                ISelfTestable selfTestableOrNull = iSelfTestableArray[n2];
                if (selfTestableOrNull != null) {
                    selfTestableOrNull.check();
                }
                ++n2;
            }
        }
        catch (HighLevelException e) {
            System.err.printf("Etlserver self test failed: [%s: %s]\n", e.getClass().getSimpleName(), e.getMessage());
            exitHandler.exit(1);
        }
        catch (RuntimeException e) {
            System.err.println("Etlserver self test failed:");
            e.printStackTrace();
            exitHandler.exit(1);
        }
        if (TimerUtilities.isOperational()) {
            if (operationLog.isInfoEnabled()) {
                operationLog.info("Timer task interruption is operational.");
            }
        } else {
            operationLog.warn("Timer task interruption is not operational. No clean up can be performed on extraordinary shutdown.");
        }
    }

    private static void checkFullyAccessible(File directory) throws ConfigurationFailureException {
        String errorMessage;
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("Checking source directory '" + directory.getAbsolutePath() + "'.");
        }
        if ((errorMessage = FileUtilities.checkDirectoryFullyAccessible(directory, "source")) != null) {
            throw new ConfigurationFailureException(errorMessage);
        }
    }

    private static IETLLIMSService getETLLIMSService(Parameters parameters) {
        String serviceURL = Main.getServiceURL(parameters);
        IETLLIMSService service = ServiceRegistry.getLIMSServiceFactory().createETLLIMSService(serviceURL);
        return service;
    }

    private static String getServiceURL(Parameters parameters) {
        String serverURL = parameters.getServerURL();
        if (serverURL == null) {
            throw new EnvironmentFailureException("Application Server URL is not defined.");
        }
        return serverURL;
    }

    private static void startupServer(Parameters parameters) {
        LinkedHashMap<String, IProcessorFactory> processorFactories = new LinkedHashMap<String, IProcessorFactory>();
        Map<String, Properties> processorProperties = parameters.getProcessorProperties();
        for (Map.Entry<String, Properties> entry : processorProperties.entrySet()) {
            processorFactories.put(entry.getKey(), StandardProcessorFactory.create(entry.getValue()));
        }
        ThreadParameters[] threads = parameters.getThreads();
        IEncapsulatedLimsService authorizedLimsService = Main.createAuthorizedLimsService(parameters);
        IFreeDiskspaceProvider freeDiskspaceProviderOrNull = Main.tryCreateFreeDiskspaceProvider(parameters);
        boolean notify = true;
        ThreadParameters[] threadParametersArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadParameters threadParameters = threadParametersArray[n2];
            Main.createProcessingThread(parameters, threadParameters, authorizedLimsService, freeDiskspaceProviderOrNull, notify, processorFactories);
            notify = false;
            ++n2;
        }
    }

    private static IFreeDiskspaceProvider tryCreateFreeDiskspaceProvider(Parameters parameters) {
        ThreadParameters[] threads = parameters.getThreads();
        if (parameters.getHighwaterMarkKb() > 0L && threads.length > 0) {
            File storeRootPath = threads[0].getPlugin().getStorageProcessor().getStoreRootDirectory();
            return new CachingFreeDiskspaceProvider(new LocalFreeDiskspaceProvider(storeRootPath));
        }
        return null;
    }

    private static IEncapsulatedLimsService createAuthorizedLimsService(Parameters parameters) {
        String username = parameters.getUsername();
        String password = parameters.getPassword();
        IETLLIMSService limsService = Main.getETLLIMSService(parameters);
        return new EncapsulatedLimsService(limsService, username, password);
    }

    private static void createProcessingThread(Parameters parameters, ThreadParameters threadParameters, IEncapsulatedLimsService authorizedLimsService, IFreeDiskspaceProvider freeDiskspaceProviderOrNull, boolean notify, Map<String, IProcessorFactory> processorFactories) {
        File incomingDataDirectory = threadParameters.getIncomingDataDirectory();
        IETLServerPlugin plugin = threadParameters.getPlugin();
        String instanceCode = PropertyUtils.getMandatoryProperty(parameters.getProperties(), INSTANCE_CODE_KEY);
        TransferredDataSetHandler mover = new TransferredDataSetHandler(instanceCode, plugin, authorizedLimsService, parameters);
        mover.setProcessorFactories(processorFactories);
        Main.selfTest(incomingDataDirectory, authorizedLimsService, mover);
        TimerTask task = Main.createWorker(mover, freeDiskspaceProviderOrNull, notify, incomingDataDirectory, parameters);
        String timerThreadName = String.valueOf(threadParameters.getThreadName()) + " - Incoming Data Monitor";
        Timer workerTimer = new Timer(timerThreadName);
        workerTimer.schedule(task, 0L, parameters.getCheckIntervalMillis());
        Main.addShutdownHookForCleanup(workerTimer, mover, parameters.getShutdownTimeOutMillis(), threadParameters.getThreadName());
    }

    private static TimerTask createWorker(TransferredDataSetHandler mover, IFreeDiskspaceProvider freeDiskspaceProviderOrNull, boolean notify, File incomingDataDirectory, Parameters parameters) {
        DirectoryScanningTimerTask workerTask = new DirectoryScanningTimerTask(incomingDataDirectory, new NamePrefixFileFilter(".MARKER_is_finished_", true), mover);
        if (freeDiskspaceProviderOrNull != null) {
            return new HighwaterMarkGuard(workerTask, freeDiskspaceProviderOrNull, parameters.getHighwaterMarkKb(), notify);
        }
        return workerTask;
    }

    private static void addShutdownHookForCleanup(final Timer workerTimer, final TransferredDataSetHandler mover, final long timeoutMillis, final String threadName) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                try {
                    try {
                        if (operationLog.isInfoEnabled()) {
                            operationLog.info("Requesting shutdown lock of thread '" + threadName + "'.");
                        }
                        long startTimeMillis = System.currentTimeMillis();
                        boolean lockOK = mover.getRegistrationLock().tryLock(timeoutMillis, TimeUnit.MILLISECONDS);
                        long timeoutLeftMillis = Math.max(timeoutMillis / 2L, timeoutMillis - (System.currentTimeMillis() - startTimeMillis));
                        if (!lockOK) {
                            operationLog.error("Failed to get lock for shutdown of thread '" + threadName + "'.");
                        }
                        try {
                            if (operationLog.isInfoEnabled()) {
                                operationLog.info(String.format("Initiating shutdown sequence [maximal shutdown time: %ds].", 2L * timeoutLeftMillis / 1000L));
                            }
                            boolean shutdownOK = TimerUtilities.tryShutdownTimer(workerTimer, timeoutLeftMillis);
                            operationLog.log(shutdownOK ? Level.INFO : Level.ERROR, "Worker thread shutdown, status=" + (shutdownOK ? "OK" : "FAILED"));
                        }
                        finally {
                            if (lockOK) {
                                mover.getRegistrationLock().unlock();
                            }
                        }
                        operationLog.warn("Shutting down shredder(s)");
                        QueueingPathRemoverService.stopAndWait(timeoutMillis);
                    }
                    catch (InterruptedException ex) {
                        throw new StopException(ex);
                    }
                }
                finally {
                    if (operationLog.isInfoEnabled()) {
                        operationLog.info("Shutting down now.");
                    }
                }
            }
        }, String.valueOf(threadName) + " - Shutdown Handler"));
    }

    public static void main(String[] args) {
        ServiceRegistry.setLIMSServiceFactory(RMIBasedLIMSServiceFactory.INSTANCE);
        if (Main.checkListShredder(args)) {
            System.exit(0);
        }
        Main.initLog();
        Parameters parameters = new Parameters(args);
        TimingParameters.setDefault(parameters.getTimingParameters());
        QueueingPathRemoverService.start(shredderQueueFile);
        Main.printInitialLogMessage(parameters);
        Main.startupServer(parameters);
        operationLog.info("etlserver ready and waiting for data.");
    }
}

