/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.threev;

import ch.systemsx.cisd.bds.hcs.Geometry;
import ch.systemsx.cisd.bds.hcs.Location;
import ch.systemsx.cisd.bds.hcs.WellGeometry;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.IFile;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.StopException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.ChannelSetHelper;
import ch.systemsx.cisd.etlserver.DataSetInformation;
import ch.systemsx.cisd.etlserver.HCSImageFileExtractionResult;
import ch.systemsx.cisd.etlserver.IHCSImageFileAccepter;
import ch.systemsx.cisd.etlserver.IHCSImageFileExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class HCSImageFileExtractor
implements IHCSImageFileExtractor {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, HCSImageFileExtractor.class);
    static final String IMAGE_FILE_NOT_STANDARDIZABLE = "Image file '%s' could not be standardized given following tokens [plateLocation=%s,wellLocation=%s,channel=%s].";
    static final String IMAGE_FILE_ACCEPTED = "Image file '%s' was accepted for channel %d, plate location %s and well location %s.";
    static final String FILE_PREFIX = "Screening_";
    static final int TOKEN_NUMBER = 5;
    static final char TOKEN_SEPARATOR = '_';
    private final Geometry wellGeometry;

    public HCSImageFileExtractor(Properties properties) {
        assert (properties != null) : "Given properites should not be null";
        this.wellGeometry = HCSImageFileExtractor.getWellGeometry(properties);
    }

    private static final Geometry getWellGeometry(Properties properties) {
        String property = properties.getProperty("well_geometry");
        if (property == null) {
            throw new ConfigurationFailureException(String.format("No '%s' property has been specified.", "well_geometry"));
        }
        Geometry geometry = WellGeometry.createFromString(property);
        if (geometry == null) {
            throw new ConfigurationFailureException(String.format("Could not create a geometry from property value '%s'.", property));
        }
        return geometry;
    }

    private final Location tryGetWellLocation(String value) {
        if (value.startsWith("s")) {
            String tileNo = value.substring("s".length());
            try {
                return Location.tryCreateLocationFromPosition(Integer.parseInt(tileNo), this.wellGeometry);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    private static final Location tryGetPlateLocation(String value) {
        return Location.tryCreateLocationFromMatrixCoordinate(value);
    }

    private final int getWavelength(String value) {
        if (value.startsWith("w")) {
            try {
                return Integer.parseInt(value.substring("w".length()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    public final HCSImageFileExtractionResult process(IDirectory incomingDataSetDirectory, DataSetInformation dataSetInformation, IHCSImageFileAccepter accepter) {
        assert (incomingDataSetDirectory != null);
        List<IFile> imageFiles = incomingDataSetDirectory.listFiles(new String[]{"tif", "tiff"}, true);
        long start = System.currentTimeMillis();
        ArrayList<IFile> invalidFiles = new ArrayList<IFile>();
        ChannelSetHelper helper = new ChannelSetHelper();
        for (IFile imageFile : imageFiles) {
            String[] tokens;
            String baseName;
            StopException.check();
            if (operationLog.isDebugEnabled()) {
                operationLog.debug(String.format("Processing image file '%s'", imageFile));
            }
            if (!(baseName = FilenameUtils.getBaseName((String)imageFile.getPath())).startsWith(FILE_PREFIX) || (tokens = StringUtils.split((String)baseName, (char)'_')).length != 5) continue;
            Location plateLocation = HCSImageFileExtractor.tryGetPlateLocation(tokens[1]);
            Location wellLocation = this.tryGetWellLocation(tokens[2]);
            int wavelength = this.getWavelength(tokens[3]);
            if (wellLocation != null && plateLocation != null && wavelength > 0) {
                helper.addWavelength(wavelength);
                accepter.accept(wavelength, plateLocation, wellLocation, imageFile);
                if (!operationLog.isDebugEnabled()) continue;
                operationLog.debug(String.format(IMAGE_FILE_ACCEPTED, imageFile, wavelength, plateLocation, wellLocation));
                continue;
            }
            if (operationLog.isDebugEnabled()) {
                operationLog.debug(String.format(IMAGE_FILE_NOT_STANDARDIZABLE, imageFile, tokens[0], tokens[1], tokens[2]));
            }
            invalidFiles.add(imageFile);
        }
        return new HCSImageFileExtractionResult(System.currentTimeMillis() - start, imageFiles.size(), Collections.unmodifiableList(invalidFiles), helper.getChannelSet());
    }
}

