/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.collections;

import ch.systemsx.cisd.common.collections.FilteredCollection;
import ch.systemsx.cisd.common.collections.Validator;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilteredList<E>
extends FilteredCollection<E>
implements List<E> {
    protected FilteredList(List<E> list, Validator<E> validator) {
        super(list, validator);
    }

    public static <E> List<E> decorate(List<E> list, Validator<E> validator) {
        return new FilteredList<E>(list, validator);
    }

    protected List<E> getList() {
        return (List)this.getCollection();
    }

    @Override
    public E get(int index) {
        return this.getList().get(index);
    }

    @Override
    public int indexOf(Object object) {
        return this.getList().indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getList().lastIndexOf(object);
    }

    @Override
    public E remove(int index) {
        return this.getList().remove(index);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.getList().listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int i) {
        return this.getList().listIterator(i);
    }

    @Override
    public E set(int index, E object) {
        if (this.isValid(object)) {
            return this.getList().set(index, object);
        }
        return null;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new FilteredList<E>(this.getList().subList(fromIndex, toIndex), this.validator);
    }

    @Override
    public void add(int index, E object) {
        if (this.isValid(object)) {
            this.getList().add(index, object);
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        return this.getList().addAll(index, FilteredList.filterCollection(collection, this.validator));
    }
}

