/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.concurrent;

import ch.systemsx.cisd.common.concurrent.ExecutionStatus;
import ch.systemsx.cisd.common.utilities.ModifiedShortPrefixToStringStyle;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutionResult<T> {
    private final ExecutionStatus status;
    private final T resultOrNull;
    private final Throwable exceptionOrNull;

    private ExecutionResult(ExecutionStatus status, T resultOrNull, Throwable exceptionOrNull) {
        this.status = status;
        this.resultOrNull = resultOrNull;
        this.exceptionOrNull = exceptionOrNull;
    }

    static final <T> ExecutionResult<T> create(T resultOrNull) {
        return new ExecutionResult<T>(ExecutionStatus.COMPLETE, resultOrNull, null);
    }

    static final <T> ExecutionResult<T> createExceptional(Throwable exception) {
        assert (exception != null);
        return new ExecutionResult<Object>(ExecutionStatus.EXCEPTION, null, exception);
    }

    static final <T> ExecutionResult<T> createTimedOut() {
        return new ExecutionResult<Object>(ExecutionStatus.TIMED_OUT, null, null);
    }

    static final <T> ExecutionResult<T> createInterrupted() {
        return new ExecutionResult<Object>(ExecutionStatus.INTERRUPTED, null, null);
    }

    public final ExecutionStatus getStatus() {
        return this.status;
    }

    public final T tryGetResult() {
        return this.resultOrNull;
    }

    public final Throwable tryGetException() {
        return this.exceptionOrNull;
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString(this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
    }
}

