/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.TimingParameters;
import ch.systemsx.cisd.common.concurrent.MonitoringProxy;
import ch.systemsx.cisd.common.exceptions.WrappedIOException;
import ch.systemsx.cisd.common.filesystem.FileLinkUtilities;
import ch.systemsx.cisd.common.utilities.IFileImmutableCopier;
import java.io.File;

public class FastHardLinkMaker
implements IFileImmutableCopier {
    private static final IFileImmutableCopier nativeCopier = new IFileImmutableCopier(){

        public boolean copyFileImmutably(File source, File destinationDirectory, String nameOrNull) {
            File destination = new File(destinationDirectory, nameOrNull == null ? source.getName() : nameOrNull);
            try {
                FileLinkUtilities.createHardLink(source.getAbsolutePath(), destination.getAbsolutePath());
                return true;
            }
            catch (WrappedIOException wrappedIOException) {
                return false;
            }
        }
    };
    private final IFileImmutableCopier monitoringProxy;

    public static final boolean isOperational() {
        return FileLinkUtilities.isOperational();
    }

    public static final IFileImmutableCopier tryCreate(TimingParameters timingParameters) {
        if (!FileLinkUtilities.isOperational()) {
            return null;
        }
        return new FastHardLinkMaker(timingParameters);
    }

    public static final IFileImmutableCopier tryCreate() {
        if (!FileLinkUtilities.isOperational()) {
            return null;
        }
        return new FastHardLinkMaker(TimingParameters.getDefaultParameters());
    }

    private FastHardLinkMaker(TimingParameters timingParameters) {
        this.monitoringProxy = MonitoringProxy.create(IFileImmutableCopier.class, nativeCopier).timing(timingParameters).get();
    }

    public boolean copyFileImmutably(File file, File destinationDirectory, String nameOrNull) {
        return this.monitoringProxy.copyFileImmutably(file, destinationDirectory, nameOrNull);
    }
}

