/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public abstract class FileWatcher
extends TimerTask {
    static final String DOES_NOT_EXIST_FORMAT = "Given file '%s' does not exist.";
    static final String HAS_NOT_CHANGED_FORMAT = "Watched file '%s' did not change.";
    static final String HAS_CHANGED_FORMAT = "Watched file '%s' has changed.";
    static final String PERMISSION_EXCEPTION_FORMAT = "Was not allowed to check existence of file '%s'.";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FileWatcher.class);
    private static final IFileWatcherState DEFAULT_FILE_WATCHER_STATE = new LastModifiedState();
    private final File fileToWatch;
    private final IFileWatcherState fileWatcherState;
    private boolean warnedAlready = false;

    public FileWatcher(File fileToWatch) {
        this(fileToWatch, DEFAULT_FILE_WATCHER_STATE);
    }

    public FileWatcher(File fileToWatch, IFileWatcherState fileWatcherState) {
        this.fileToWatch = fileToWatch;
        this.fileWatcherState = fileWatcherState;
        fileWatcherState.saveInitialState(fileToWatch);
    }

    public final File getFileToWatch() {
        return this.fileToWatch;
    }

    protected abstract void onChange();

    public final void run() {
        boolean fileExists = false;
        try {
            fileExists = this.fileToWatch.exists();
        }
        catch (SecurityException e) {
            operationLog.warn(String.format(PERMISSION_EXCEPTION_FORMAT, this.fileToWatch), e);
            return;
        }
        if (fileExists) {
            if (this.fileWatcherState.stateChanged(this.fileToWatch)) {
                if (operationLog.isDebugEnabled()) {
                    operationLog.debug(String.format(HAS_CHANGED_FORMAT, this.fileToWatch));
                }
                this.onChange();
                this.warnedAlready = false;
            } else if (operationLog.isTraceEnabled()) {
                operationLog.trace(String.format(HAS_NOT_CHANGED_FORMAT, this.fileToWatch));
            }
        } else if (!this.warnedAlready) {
            operationLog.warn(String.format(DOES_NOT_EXIST_FORMAT, this.fileToWatch));
            this.warnedAlready = true;
        }
    }

    public static interface IFileWatcherState {
        public void saveInitialState(File var1);

        public boolean stateChanged(File var1);
    }

    public static final class LastModifiedState
    implements IFileWatcherState {
        private long lastModified;

        public final void saveInitialState(File fileToWatch) {
            this.lastModified = fileToWatch.lastModified();
        }

        public final boolean stateChanged(File fileToWatch) {
            long current = fileToWatch.lastModified();
            if (current > this.lastModified) {
                this.lastModified = current;
                return true;
            }
            return false;
        }
    }
}

