/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import java.util.Random;

public class PasswordGenerator {
    private final Random random;

    public PasswordGenerator() {
        this(new Random());
    }

    public PasswordGenerator(Random random) {
        assert (random != null) : "Unspecified random number generator.";
        this.random = random;
    }

    public String generatePassword(int length) {
        State state = State.DIGIT;
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < length) {
            state = state.nextState(this.random);
            state.appendCharacterTo(builder, this.random);
            ++i;
        }
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        DIGIT{

            State nextState(Random random) {
                return random.nextBoolean() ? CONSONANT : VOWEL;
            }

            String getCharacters() {
                return "0123456789";
            }
        }
        ,
        CONSONANT{

            State nextState(Random random) {
                return random.nextBoolean() ? DIGIT : VOWEL;
            }

            String getCharacters() {
                return "bdcfghjklmnpqrstvwxzBCDFGHJKLMNPQRSTVWXZ";
            }
        }
        ,
        VOWEL{

            State nextState(Random random) {
                return random.nextBoolean() ? CONSONANT : DIGIT;
            }

            String getCharacters() {
                return "aeiouyAEIOUY";
            }
        };


        State nextState(Random random) {
            return this;
        }

        void appendCharacterTo(StringBuilder builder, Random random) {
            String characters = this.getCharacters();
            builder.append(characters.charAt(random.nextInt(characters.length())));
        }

        abstract String getCharacters();
    }
}

