/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.dbmigration.DatabaseEngine;
import ch.systemsx.cisd.dbmigration.IDAOFactory;
import ch.systemsx.cisd.dbmigration.IDataSourceFactory;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.jdbc.support.lob.LobHandler;

public class DatabaseConfigurationContext
implements DisposableBean {
    private ISequenceNameMapper sequenceNameMapper;
    private String adminUser;
    private String adminPassword;
    private String scriptFolder;
    private String databaseKind;
    private DatabaseEngine databaseEngine;
    private boolean createFromScratch;
    private boolean scriptSingleStepMode;
    private IDataSourceFactory dataSourceFactory = new BasicDataSourceFactory();
    private DataSource dataSource;
    private DataSource adminDataSource;
    private String owner;
    private String password;
    private String basicDatabaseName;
    private String databaseName;
    private String urlHostPart;
    private String groupCode;

    public DatabaseConfigurationContext() {
        this.setOwner(null);
        this.setPassword("");
    }

    public final void setDataSourceFactory(IDataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    public final String getGroupCode() throws ConfigurationFailureException {
        return this.groupCode;
    }

    public final void setGroupCode(String groupCode) throws ConfigurationFailureException {
        this.groupCode = groupCode;
    }

    private static final void closeConnection(DataSource dataSource) {
        if (dataSource != null) {
            try {
                if (dataSource instanceof BasicDataSource) {
                    ((BasicDataSource)dataSource).close();
                }
                if (dataSource instanceof DisposableBean) {
                    ((DisposableBean)dataSource).destroy();
                }
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    private void checkDatabaseEngine() {
        if (this.databaseEngine == null) {
            throw new ConfigurationFailureException("No db engine defined.");
        }
    }

    private final DataSource createDataSource() {
        String dsDriver = this.getDriver();
        String url = this.getDatabaseURL();
        return this.dataSourceFactory.createDataSource(dsDriver, url, this.owner, this.password);
    }

    private final String getUrl(String dsDatabaseName) throws ConfigurationFailureException {
        this.checkDatabaseEngine();
        return this.databaseEngine.getURL(this.urlHostPart, dsDatabaseName);
    }

    private final String getDriver() throws ConfigurationFailureException {
        this.checkDatabaseEngine();
        return this.databaseEngine.getDriverClass();
    }

    private final String getAdminUser() throws ConfigurationFailureException {
        if (this.adminUser == null) {
            this.checkDatabaseEngine();
            return this.databaseEngine.getDefaultAdminUser();
        }
        return this.adminUser;
    }

    private final String getAdminPassword() {
        return this.adminPassword;
    }

    private final String getDatabaseKind() {
        return this.databaseKind;
    }

    public final String getDatabaseURL() {
        String dsDatabaseName = this.getDatabaseName();
        if (dsDatabaseName == null) {
            throw new ConfigurationFailureException("No db name defined.");
        }
        String url = this.getUrl(dsDatabaseName);
        return url;
    }

    public final DataSource getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = this.createDataSource();
        }
        return this.dataSource;
    }

    public String getBasicDatabaseName() {
        return this.basicDatabaseName;
    }

    public final DataSource getAdminDataSource() throws ConfigurationFailureException {
        if (this.adminDataSource == null) {
            this.adminDataSource = this.dataSourceFactory.createDataSource(this.getDriver(), this.getAdminURL(), this.getAdminUser(), this.getAdminPassword());
        }
        return this.adminDataSource;
    }

    public final String getOwner() {
        return this.owner;
    }

    public final void setOwner(String owner) {
        this.owner = StringUtils.isBlank(owner) ? System.getProperty("user.name").toLowerCase() : owner;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String password) {
        this.password = password == null ? "" : password;
    }

    public final void setAdminUser(String adminUser) {
        this.adminUser = adminUser != null && adminUser.length() == 0 ? null : StringUtils.trim(adminUser);
    }

    public void setBasicDatabaseName(String basicDatabaseName) {
        this.basicDatabaseName = StringUtils.trim(basicDatabaseName);
    }

    public String getDatabaseName() {
        if (this.databaseName == null) {
            this.databaseName = String.valueOf(this.getBasicDatabaseName()) + "_" + this.getDatabaseKind();
        }
        return this.databaseName;
    }

    public final void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public final String getUrlHostPart() {
        return this.urlHostPart;
    }

    public final void setUrlHostPart(String urlHostPart) {
        this.urlHostPart = urlHostPart != null && urlHostPart.length() == 0 ? null : StringUtils.trim(urlHostPart);
    }

    private final String getAdminURL() throws ConfigurationFailureException {
        this.checkDatabaseEngine();
        return this.databaseEngine.getAdminURL(this.urlHostPart, this.getDatabaseName());
    }

    public final LobHandler getLobHandler() throws ConfigurationFailureException {
        this.checkDatabaseEngine();
        return this.databaseEngine.getLobHandler();
    }

    public final ISequencerHandler getSequencerHandler() throws ConfigurationFailureException {
        this.checkDatabaseEngine();
        return this.databaseEngine.getSequenceHandler();
    }

    public final ISequenceNameMapper getSequenceNameMapper() {
        return this.sequenceNameMapper;
    }

    public final void setSequenceNameMapper(ISequenceNameMapper sequenceNameMapper) {
        this.sequenceNameMapper = sequenceNameMapper;
    }

    public final boolean isCreateFromScratch() {
        return this.createFromScratch;
    }

    public final void setCreateFromScratch(boolean createFromScratch) {
        this.createFromScratch = createFromScratch;
    }

    public final boolean isScriptSingleStepMode() {
        return this.scriptSingleStepMode;
    }

    public final void setScriptSingleStepMode(boolean singleStepMode) {
        this.scriptSingleStepMode = singleStepMode;
    }

    public final void setDatabaseKind(String databaseKind) {
        this.databaseKind = StringUtils.trim(databaseKind);
    }

    public final String getDatabaseEngineCode() throws ConfigurationFailureException {
        if (this.databaseEngine == null) {
            throw new ConfigurationFailureException("No database engine defined.");
        }
        return this.databaseEngine.getCode();
    }

    public final void setDatabaseEngineCode(String databaseEngineCode) throws ConfigurationFailureException {
        this.databaseEngine = DatabaseEngine.getEngineForCode(StringUtils.trim(databaseEngineCode));
    }

    public final IDAOFactory createDAOFactory() {
        return this.databaseEngine.createDAOFactory(this);
    }

    public final String getScriptFolder() {
        return this.scriptFolder;
    }

    public final void setScriptFolder(String scriptFolder) {
        this.scriptFolder = scriptFolder;
    }

    public final void closeConnections() {
        DatabaseConfigurationContext.closeConnection(this.dataSource);
        this.dataSource = null;
        DatabaseConfigurationContext.closeConnection(this.adminDataSource);
        this.adminDataSource = null;
    }

    public final void destroy() throws Exception {
        this.closeConnections();
    }

    private static final class BasicDataSourceFactory
    implements IDataSourceFactory {
        private BasicDataSourceFactory() {
        }

        public DataSource createDataSource(String driver, String url, String owner, String password) {
            BasicDataSource dataSource = new BasicDataSource();
            dataSource.setDriverClassName(driver);
            dataSource.setUrl(url);
            dataSource.setUsername(owner);
            dataSource.setPassword(password);
            dataSource.setMinIdle(0);
            dataSource.setMaxIdle(0);
            return dataSource;
        }
    }
}

