/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSet {
    private final Map<String, List<String>> map = new HashMap<String, List<String>>();
    private final Map<String, String> namesOfNonEmptyColums = new LinkedHashMap<String, String>();

    public final List<String> tryGetList(String listName) {
        assert (listName != null) : "List name can not be null.";
        return this.map.get(listName);
    }

    public final void addToList(String listUniqueName, String listLabel, String value) {
        List<String> list;
        assert (listUniqueName != null) : "List name can not be null.";
        if (StringUtils.isNotEmpty(value)) {
            this.checkAndPutColumnName(listUniqueName, listLabel);
        }
        if ((list = this.map.get(listUniqueName)) == null) {
            list = new ArrayList<String>();
            this.map.put(listUniqueName, list);
        }
        list.add(value);
    }

    private String checkAndPutColumnName(String listUniqueName, String listLabel) {
        String prevLabel = this.namesOfNonEmptyColums.get(listUniqueName);
        if (prevLabel != null && !prevLabel.equals(listLabel)) {
            throw new IllegalStateException("Different labels detected for the same column code " + listUniqueName + ". The new one is " + listLabel + ", the previous one was " + prevLabel);
        }
        return this.namesOfNonEmptyColums.put(listUniqueName, listLabel);
    }

    public final String tryGetValueAt(String listName, int rowIndex) {
        List<String> list = this.tryGetList(listName);
        if (list == null) {
            return null;
        }
        return list.get(rowIndex);
    }

    public final String getLabel(String listName) {
        return this.namesOfNonEmptyColums.get(listName);
    }

    public final Set<String> getNamesOfNonEmptyColumns() {
        return Collections.unmodifiableSet(this.namesOfNonEmptyColums.keySet());
    }

    public final int getRowCount() {
        int rowCount = 0;
        for (List<String> list : this.map.values()) {
            int size = list.size();
            assert (rowCount == 0 || size == rowCount) : String.format("Lists do not have the same number of rows (%d != %d)", size, rowCount);
            rowCount = Math.max(rowCount, size);
        }
        return rowCount;
    }

    public final void mergeLists(ListSet newListSet) {
        int originalRowCount = this.getRowCount();
        Set<String> newNonEmptyColumnNames = newListSet.getNamesOfNonEmptyColumns();
        for (String newColumnName : newNonEmptyColumnNames) {
            List<String> originalColumn = this.getOrGenerateList(newColumnName, originalRowCount);
            List<String> newColumn = newListSet.tryGetList(newColumnName);
            assert (newColumn != null) : "expected column " + newColumnName;
            originalColumn.addAll(newColumn);
            this.checkAndPutColumnName(newColumnName, newListSet.getLabel(newColumnName));
            this.map.put(newColumnName, originalColumn);
        }
        List<String> emptyNewColumn = ListSet.generateEmptyList(newListSet.getRowCount());
        for (String orgiginalColumnName : this.map.keySet()) {
            if (newNonEmptyColumnNames.contains(orgiginalColumnName)) continue;
            List<String> orgiginalColumn = this.tryGetList(orgiginalColumnName);
            assert (orgiginalColumn != null) : "expected column " + orgiginalColumnName;
            orgiginalColumn.addAll(emptyNewColumn);
            this.map.put(orgiginalColumnName, orgiginalColumn);
        }
    }

    private List<String> getOrGenerateList(String newColName, int originalRowCount) {
        List<String> originalColumnOrNull = this.tryGetList(newColName);
        if (originalColumnOrNull != null) {
            return originalColumnOrNull;
        }
        return ListSet.generateEmptyList(originalRowCount);
    }

    private static List<String> generateEmptyList(int size) {
        return new ArrayList<String>((Collection)Collections.nCopies(size, null));
    }
}

