/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.base.masterplate;

import ch.systemsx.cisd.common.utilities.MatrixComparator;
import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.ListSet;
import ch.systemsx.cisd.lims.base.Material;
import ch.systemsx.cisd.lims.base.MaterialBatch;
import ch.systemsx.cisd.lims.base.SampleComponent;
import ch.systemsx.cisd.lims.base.SampleCriteria;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterPlateLoader {
    public static final String GENE_SYMBOL_PROPERTY_CODE = "USER.GENE_SYMBOL";
    static final SampleComponentComparator SAMPLE_COMPONENT_COMPARATOR = new SampleComponentComparator();
    private final boolean markControlLayoutWells;

    public static ListSet createTable(SampleComponent[] sampleComponents, boolean markControlWells) {
        MasterPlateLoader masterPlateLoader = new MasterPlateLoader(markControlWells);
        return masterPlateLoader.createTable(sampleComponents);
    }

    private MasterPlateLoader(boolean markControlWells) {
        this.markControlLayoutWells = markControlWells;
    }

    private ListSet createTable(SampleComponent[] sampleComponents) {
        Arrays.sort(sampleComponents, SAMPLE_COMPONENT_COMPARATOR);
        HashMap<String, ListSet> wellsByMaterialType = new HashMap<String, ListSet>();
        SampleComponent[] sampleComponentArray = sampleComponents;
        int n = sampleComponents.length;
        int n2 = 0;
        while (n2 < n) {
            SampleComponent component = sampleComponentArray[n2];
            String materialTypeCode = MasterPlateLoader.getMaterialTypeCode(component);
            ListSet materialListSet = (ListSet)wellsByMaterialType.get(materialTypeCode);
            if (materialListSet == null) {
                materialListSet = new ListSet();
                wellsByMaterialType.put(materialTypeCode, materialListSet);
            }
            this.addRow(materialListSet, component);
            ++n2;
        }
        return this.mergeLists(wellsByMaterialType.values());
    }

    private ListSet mergeLists(Iterable<ListSet> listSets) {
        ListSet result = new ListSet();
        for (ListSet listSet : listSets) {
            result.mergeLists(listSet);
            assert (result.getRowCount() > 0) : "never triggered, the real assert is in getRowCount()";
        }
        return result;
    }

    private static String getMaterialTypeCode(SampleComponent component) {
        return component.getMaterialBatch().getMaterial().getMaterialType().getCode();
    }

    private void addRow(ListSet listSet, SampleComponent component) {
        this.addToList(listSet, FieldName.WELL, component.getCode());
        MaterialBatch mb = component.getMaterialBatch();
        this.addToList(listSet, FieldName.MATERIAL_BATCH, mb.getCode());
        Material material = mb.getMaterial();
        this.addToList(listSet, FieldName.MATERIAL_CODE, material.getCode());
        String materialTypeCode = material.getMaterialType().getCode();
        this.addToList(listSet, FieldName.MATERIAL_TYPE, this.markOrigin(materialTypeCode, component));
        this.fillInhibitedGeneInfoIfOligo(listSet, material);
        this.fillProperties(material, listSet);
    }

    private void fillInhibitedGeneInfoIfOligo(ListSet listSet, Material material) {
        if (!"OLIGO".equals(material.getMaterialType().getCode())) {
            return;
        }
        Material inhibitorOf = material.getInhibitorOf();
        if (inhibitorOf == null) {
            return;
        }
        String geneCode = inhibitorOf.getCode();
        this.addToList(listSet, FieldName.GENE_ID, geneCode);
        this.fillGeneSymbol(listSet, inhibitorOf);
    }

    private void fillGeneSymbol(ListSet listSet, Material inhibitorOf) {
        SimpleEntityProperty geneSymbolPropertyOrNull = MasterPlateLoader.tryFindProperty(inhibitorOf.getProperties(), GENE_SYMBOL_PROPERTY_CODE);
        if (geneSymbolPropertyOrNull == null) {
            return;
        }
        listSet.addToList(geneSymbolPropertyOrNull.getCode(), geneSymbolPropertyOrNull.getUserLabel(), geneSymbolPropertyOrNull.getUntypedValue());
    }

    private void addToList(ListSet listSet, FieldName fieldName, String value) {
        listSet.addToList(fieldName.getName(false), fieldName.getName(true), value);
    }

    private void fillProperties(Material material, ListSet listSet) {
        SimpleEntityProperty[] simpleEntityPropertyArray = material.getProperties();
        int n = simpleEntityPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleEntityProperty property = simpleEntityPropertyArray[n2];
            String propertyValue = property.getUntypedValue();
            listSet.addToList(property.getCode(), property.getUserLabel(), propertyValue);
            ++n2;
        }
    }

    private static SimpleEntityProperty tryFindProperty(SimpleEntityProperty[] properties, String propertyCode) {
        SimpleEntityProperty[] simpleEntityPropertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleEntityProperty prop = simpleEntityPropertyArray[n2];
            if (prop.getCode().equals(propertyCode)) {
                return prop;
            }
            ++n2;
        }
        return null;
    }

    private String markOrigin(String textToMark, SampleComponent sampleComponent) {
        String result = textToMark;
        if (this.markControlLayoutWells && MasterPlateLoader.isControlLayoutWell(sampleComponent)) {
            result = "*" + result;
        }
        return result;
    }

    private static boolean isControlLayoutWell(SampleComponent sampleComponent) {
        SampleCriteria sampleCriteria = sampleComponent.getSampleCriteria();
        return sampleCriteria != null && SampleTypeCode.CONTROL_LAYOUT.getCode().equals(sampleCriteria.getSampleTypeCode());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SampleComponentComparator
    implements Comparator<SampleComponent>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final MatrixComparator MATRIX_COMPARATOR = new MatrixComparator();

        private SampleComponentComparator() {
        }

        @Override
        public final int compare(SampleComponent o1, SampleComponent o2) {
            return MATRIX_COMPARATOR.compare(o1.getCode(), o2.getCode());
        }
    }
}

