/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyObjectFactory;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.lims.base.EntityType;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.Material;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.base.properties.EntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.IEntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityPropertySchema;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.commands.AbstractFileParameters;
import ch.systemsx.cisd.lims.client.commands.BisTabFileLoader;
import ch.systemsx.cisd.lims.client.commands.MaterialPropertiesSetter;
import ch.systemsx.cisd.lims.client.commands.factory.PropertiesParserObjectFactory;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractRegisterMaterialCommand
extends AbstractCommandWithSessionToken {
    private AbstractFileParameters parameters;

    protected abstract EntityType getMaterialType();

    protected boolean isInhibitorMandatory() {
        return false;
    }

    AbstractRegisterMaterialCommand(String name) {
        super(name);
    }

    protected AbstractFileParameters getParameters() {
        return this.parameters;
    }

    private static Material[] loadMaterials(File file, final IEntityPropertiesSchema schema, final IPropertyObjectFactory<Material> builderFactory) {
        BisTabFileLoader<Material> tabFileLoader = new BisTabFileLoader<Material>(new IParserObjectFactoryFactory<Material>(){

            @Override
            public final IParserObjectFactory<Material> createFactory(IPropertyMapper propertyMapper) {
                return new PropertiesParserObjectFactory<Material>(propertyMapper, schema, builderFactory);
            }
        });
        return tabFileLoader.load(file).toArray(new Material[0]);
    }

    @Override
    protected int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        this.parameters = this.createParameters(arguments, "materials");
        EntityType materialType = this.getMaterialType();
        String materialDescription = materialType.getDescription();
        File file = this.getParameters().getFile();
        System.out.println(String.format("Register %s from '%s'.", materialDescription, file));
        ILIMSService limsService = this.getLIMSService(this.parameters);
        IEntityPropertiesSchema schema = this.fetchTypePropertiesSchema(sessionToken, limsService);
        boolean inhibitorIsMandatory = this.isInhibitorMandatory();
        EntityType typeOfInhibited = this.getTypeOfInhibited();
        IPropertyObjectFactory<Material> builderFactory = MaterialPropertiesSetter.createFactory(materialType, schema, inhibitorIsMandatory, typeOfInhibited);
        Material[] materials = AbstractRegisterMaterialCommand.loadMaterials(file, schema, builderFactory);
        limsService.registerMaterials(sessionToken, materials, materialType.getCode());
        System.out.println(String.format("  %d %s successfully registered.", materials.length, materialDescription));
        return 0;
    }

    private IEntityPropertiesSchema fetchTypePropertiesSchema(String sessionToken, ILIMSService limsService) {
        SimpleEntityPropertySchema[] simpleSchema = limsService.listEntityPropertyTypes(sessionToken, EntityKind.MATERIAL, this.getMaterialType().getCode());
        return EntityPropertiesSchema.createFromSimple(simpleSchema);
    }

    private EntityType getTypeOfInhibited() {
        EntityType entityType = new EntityType();
        entityType.setCode("GENE");
        return entityType;
    }

    protected AbstractFileParameters createParameters(String[] arguments, String materialDescription) {
        return new Parameters(arguments, materialDescription);
    }

    protected class Parameters
    extends AbstractFileParameters {
        Parameters(String[] args, String materialDescription) {
            super(args, AbstractRegisterMaterialCommand.this.getName(), "<" + materialDescription + "-file>", SystemExit.SYSTEM_EXIT);
            if (this.getArgs().size() != 1) {
                System.err.println(String.format("Exactly one %s file must be specified.", materialDescription));
                this.printHelp(true);
            }
        }
    }
}

