/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.io.ILinePrinter;
import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.Sample;
import ch.systemsx.cisd.lims.base.SampleComponent;
import ch.systemsx.cisd.lims.base.SampleType;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.commands.GetPlateInfoCommand;
import ch.systemsx.cisd.lims.client.model.ControlLayoutTableModel;
import ch.systemsx.cisd.lims.client.output.IOutputPrinter;
import ch.systemsx.cisd.lims.client.parameters.OutputTypeParameters;
import ch.systemsx.cisd.lims.client.utilities.PersonDescriptor;
import ch.systemsx.cisd.lims.client.utilities.Utilities;
import java.util.Arrays;

public class GetControlLayoutInfoCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "get-control-layout-info";
    private static final GetControlLayoutInfoCommand INSTANCE = new GetControlLayoutInfoCommand();

    public static final synchronized GetControlLayoutInfoCommand getInstance() {
        return INSTANCE;
    }

    private GetControlLayoutInfoCommand() {
        super(NAME);
    }

    public final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        String controlLayoutCode;
        Parameters parameters = new Parameters(arguments);
        boolean prettyMode = parameters.isPrettyPrinted();
        ILIMSService limsService = this.getLIMSService(parameters);
        Sample sample = limsService.getSampleInfo(sessionToken, controlLayoutCode = parameters.getControlLayoutCode()).getGenerator();
        SampleType sampleType = sample.getSampleType();
        if (!sampleType.isControlLayout()) {
            throw UserFailureException.fromTemplate("Given plate code '%s' is a %s. Use command '%s' to display it.", controlLayoutCode, sampleType.getDescription().toLowerCase(), GetPlateInfoCommand.getInstance().getName());
        }
        SampleComponent[] sampleComponents = limsService.getSampleMergedLayout(sessionToken, controlLayoutCode).getComponents();
        if (sampleComponents.length == 0) {
            if (parameters.isPrettyPrinted()) {
                System.out.println("Empty control layout '" + controlLayoutCode + "'.");
            }
        } else {
            ILinePrinter linePrinter = GetControlLayoutInfoCommand.createSimpleLinePrinter();
            IOutputPrinter printer = GetControlLayoutInfoCommand.createPrinter(parameters, linePrinter, "<<<Control Layout Information for %s '%s'>>>");
            printer.printKeyValuePair(FieldName.CODE.getName(prettyMode), controlLayoutCode);
            PersonDescriptor.printKeyValueRegisterer(printer, sample.getRegistrator(), prettyMode);
            printer.printKeyValuePair(FieldName.REGISTRATION_DATE.getName(prettyMode), Utilities.formatDate(sample.getRegistrationDate()));
            this.printProperties(sample, printer, prettyMode);
            printer.printTableModel(new ControlLayoutTableModel(sampleComponents, prettyMode), "");
        }
        return 0;
    }

    private void printProperties(Sample sample, IOutputPrinter printer, boolean prettyMode) {
        if (sample == null) {
            return;
        }
        SimpleEntityProperty[] properties = sample.getProperties();
        if (properties != null) {
            Arrays.sort(properties, GetPlateInfoCommand.SimpleEntityPropertyComparator.INSTANCE);
            SimpleEntityProperty[] simpleEntityPropertyArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                SimpleEntityProperty property = simpleEntityPropertyArray[n2];
                String name = prettyMode ? property.getUserLabel() : property.getCode();
                printer.printKeyValuePair(name, property.getUntypedValue());
                ++n2;
            }
        }
    }

    private static final class Parameters
    extends OutputTypeParameters {
        public Parameters(String[] args) {
            super(args, GetControlLayoutInfoCommand.NAME, "<control-layout-code>");
            if (this.getArgs().size() != 1) {
                System.err.println("Exactly one <control-layout-code> must be specified.");
                this.printHelp(true);
            }
        }

        final String getControlLayoutCode() {
            return this.getArgs().get(0);
        }
    }
}

