/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.Experiment;
import ch.systemsx.cisd.lims.client.commands.AbstractExperimentInfoCommand;
import ch.systemsx.cisd.lims.client.model.ProcessingInstructionTableModel;

public final class ListProcessingInstructionsCommand
extends AbstractExperimentInfoCommand {
    private static final String NAME = "list-processing-instructions";
    private static ListProcessingInstructionsCommand instance;

    private ListProcessingInstructionsCommand() {
        super(NAME);
    }

    public static final synchronized ListProcessingInstructionsCommand getInstance() {
        if (instance == null) {
            instance = new ListProcessingInstructionsCommand();
        }
        return instance;
    }

    protected int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        AbstractExperimentInfoCommand.ExperimentInfoParameters parameters = super.createParameters(arguments);
        Experiment experiment = super.tryFetchExperimentBasicAndPrintHeader(sessionToken, parameters);
        if (experiment == null) {
            return 1;
        }
        this.printTable(new ProcessingInstructionTableModel(experiment.getProcessingInstructions(), parameters.isPrettyPrinted()), parameters);
        return 0;
    }
}

