/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.parser.IPropertiesSetter;
import ch.systemsx.cisd.common.parser.IPropertyObjectFactory;
import ch.systemsx.cisd.lims.base.EntityType;
import ch.systemsx.cisd.lims.base.Material;
import ch.systemsx.cisd.lims.base.properties.IEntityPropertiesSchema;
import ch.systemsx.cisd.lims.client.commands.AbstractPropertiesSetter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MaterialPropertiesSetter
extends AbstractPropertiesSetter<Material> {
    static final String CODE_HEADER = "code";
    static final String INHIBITOR_CODE_HEADER = "inhibitor_code";
    private final boolean inhibitorIsMandatory;
    private final EntityType materialType;
    private final EntityType typeOfInhibited;
    private String materialCode;
    private String inhibitorCodeOrNull;

    static final IPropertyObjectFactory<Material> createFactory(final EntityType type, final IEntityPropertiesSchema schema, final boolean inhibitorIsMandatory, final EntityType typeOfInhibited) {
        return new IPropertyObjectFactory<Material>(){

            @Override
            public final IPropertiesSetter<Material> createObjectSetter() {
                return new MaterialPropertiesSetter(type, schema, inhibitorIsMandatory, typeOfInhibited, null);
            }
        };
    }

    private MaterialPropertiesSetter(EntityType type, IEntityPropertiesSchema schema, boolean inhibitorIsMandatory, EntityType typeOfInhibited) {
        super(schema);
        this.materialType = type;
        this.inhibitorIsMandatory = inhibitorIsMandatory;
        this.typeOfInhibited = typeOfInhibited;
    }

    @Override
    protected final List<String> getMandatorySpecificColumns(boolean onlyMissing) {
        AbstractPropertiesSetter.ConditionalList<String> list = new AbstractPropertiesSetter.ConditionalList<String>(onlyMissing);
        list.add(CODE_HEADER, this.materialCode == null);
        list.add(INHIBITOR_CODE_HEADER, this.inhibitorIsMandatory && this.inhibitorCodeOrNull == null);
        return list.toList();
    }

    @Override
    protected final Material createEntityPropertiesHolder() {
        Material constructed = new Material();
        constructed.setCode(this.materialCode);
        constructed.setMaterialType(this.materialType);
        if (this.inhibitorCodeOrNull != null) {
            Material inhibitedMaterial = new Material();
            inhibitedMaterial.setCode(this.inhibitorCodeOrNull);
            inhibitedMaterial.setMaterialType(this.typeOfInhibited);
            constructed.setInhibitorOf(inhibitedMaterial);
        }
        return constructed;
    }

    @Override
    protected final boolean setSpecificProperty(String name, String valueOrNull) {
        boolean successful = true;
        if (name.equals(CODE_HEADER)) {
            this.materialCode = valueOrNull;
        } else if (name.equals(INHIBITOR_CODE_HEADER)) {
            this.inhibitorCodeOrNull = valueOrNull;
        } else {
            successful = false;
        }
        return successful;
    }

    /* synthetic */ MaterialPropertiesSetter(EntityType entityType, IEntityPropertiesSchema iEntityPropertiesSchema, boolean bl, EntityType entityType2, MaterialPropertiesSetter materialPropertiesSetter) {
        this(entityType, iEntityPropertiesSchema, bl, entityType2);
    }
}

