/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyObjectFactory;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.NewExperiment;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.base.properties.EntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.IEntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityPropertySchema;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.commands.BisTabFileLoader;
import ch.systemsx.cisd.lims.client.commands.ExperimentPropertiesSetter;
import ch.systemsx.cisd.lims.client.commands.factory.PropertiesParserObjectFactory;
import ch.systemsx.cisd.lims.client.parameters.AbstractParameters;
import ch.systemsx.cisd.lims.client.utilities.Utilities;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RegisterExperimentCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "register-experiments";
    private static RegisterExperimentCommand instance;

    private RegisterExperimentCommand() {
        super(NAME);
    }

    public static final synchronized RegisterExperimentCommand getInstance() {
        if (instance == null) {
            instance = new RegisterExperimentCommand();
        }
        return instance;
    }

    @Override
    public final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        ILIMSService limsService = this.getLIMSService(parameters);
        String fileName = parameters.getFile();
        String experimentTypeCode = parameters.getExperimentTypeCode();
        File rootDir = parameters.tryGetRootDir();
        File file = new File(rootDir, fileName);
        Utilities.checkAccessible(file);
        BisTabFileLoader<NewExperiment> bisTabFileLoader = RegisterExperimentCommand.createFileLoader(sessionToken, limsService, experimentTypeCode, file.getParentFile());
        System.out.println("Register experiments from '" + file.getAbsolutePath() + "'.");
        List<NewExperiment> experimentsToRegister = bisTabFileLoader.load(file);
        try {
            limsService.registerExperiments(sessionToken, experimentsToRegister.toArray(new NewExperiment[experimentsToRegister.size()]));
        }
        catch (UserFailureException e) {
            String errorIntro = "Operation failed and no experiment was registered. Reason:\n";
            throw new UserFailureException(String.valueOf(errorIntro) + e.getMessage());
        }
        for (NewExperiment experiment : experimentsToRegister) {
            ExperimentIdentifier identifier = new ExperimentIdentifier(experiment.getProjectCode(), experiment.getCode());
            System.out.println("  Experiment '" + identifier + "'" + " successfully registered.");
        }
        return 0;
    }

    private static BisTabFileLoader<NewExperiment> createFileLoader(String sessionToken, ILIMSService limsService, String experimentTypeCode, File rootDir) {
        SimpleEntityPropertySchema[] simpleSchema = limsService.listEntityPropertyTypes(sessionToken, EntityKind.EXPERIMENT, experimentTypeCode);
        final IEntityPropertiesSchema schema = EntityPropertiesSchema.createFromSimple(simpleSchema);
        final IPropertyObjectFactory<NewExperiment> factory = ExperimentPropertiesSetter.createFactory(experimentTypeCode, rootDir, schema);
        IParserObjectFactoryFactory<NewExperiment> factoryFactory = new IParserObjectFactoryFactory<NewExperiment>(){

            @Override
            public final IParserObjectFactory<NewExperiment> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                return new PropertiesParserObjectFactory<NewExperiment>(propertyMapper, schema, factory);
            }
        };
        BisTabFileLoader<NewExperiment> bisTabFileLoader = new BisTabFileLoader<NewExperiment>(factoryFactory);
        return bisTabFileLoader;
    }

    private static final class Parameters
    extends AbstractParameters {
        @Option(name="d", longName="root-dir", metaVar="directory", usage="Root directory where the files are located.")
        private String rootDir;

        public Parameters(String[] args) {
            this(args, SystemExit.SYSTEM_EXIT);
        }

        Parameters(String[] args, IExitHandler exitHandler) {
            super(args, RegisterExperimentCommand.NAME, "<experiment-type-code> <experiment-file>", exitHandler);
            if (this.getArgs().size() != 2) {
                System.err.println("Experiment type code and exactly one experiment file must be specified.");
                this.printHelp(true);
            }
        }

        final String getExperimentTypeCode() {
            return StringUtils.upperCase(this.getArgs().get(0));
        }

        final String getFile() {
            List<String> args = this.getArgs();
            String filePath = args.get(1);
            return filePath;
        }

        final File tryGetRootDir() {
            if (StringUtils.isBlank(this.rootDir)) {
                return null;
            }
            File file = new File(this.rootDir);
            if (!file.exists()) {
                throw UserFailureException.fromTemplate("Given root directory '%s' does not exist.", this.rootDir);
            }
            if (!file.isDirectory()) {
                throw UserFailureException.fromTemplate("Given root directory '%s' is not a directory.", this.rootDir);
            }
            if (!file.canRead()) {
                throw UserFailureException.fromTemplate("Given root directory '%s' can not be read.", this.rootDir);
            }
            return file;
        }
    }
}

