/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands.factory;

import ch.systemsx.cisd.common.parser.AbstractParserObjectFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.lims.base.NewSampleComponentWithFixedMaterialType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NewSampleComponentWithFixedMaterialTypeFactory
extends AbstractParserObjectFactory<NewSampleComponentWithFixedMaterialType> {
    private static final Pattern WELL_PATTERN = Pattern.compile("([A-Za-z]+)([0-9]+)");

    private NewSampleComponentWithFixedMaterialTypeFactory(IPropertyMapper propertyMapper) {
        super(NewSampleComponentWithFixedMaterialType.class, propertyMapper);
    }

    public static final NewSampleComponentWithFixedMaterialTypeFactory createInstance(IPropertyMapper propertyMapper) {
        return new NewSampleComponentWithFixedMaterialTypeFactory(propertyMapper);
    }

    static final void checkWellCode(String code) {
        if (!WELL_PATTERN.matcher(code).matches()) {
            throw new ParserException(String.format("Invalid well code '%s'. Must start with at least one letter followed by a number.", code));
        }
    }

    static final String getCanonicalCode(String code) {
        Matcher matcher = WELL_PATTERN.matcher(code);
        boolean ok = matcher.matches();
        assert (ok);
        String letters = matcher.group(1);
        String digits = matcher.group(2);
        if (digits.length() < 2) {
            digits = String.valueOf('0') + digits;
        }
        return String.valueOf(letters) + digits;
    }

    @Override
    public final NewSampleComponentWithFixedMaterialType createObject(String[] lineTokens) throws ParserException {
        NewSampleComponentWithFixedMaterialType sampleComponent = (NewSampleComponentWithFixedMaterialType)super.createObject(lineTokens);
        String code = sampleComponent.getCode();
        NewSampleComponentWithFixedMaterialTypeFactory.checkWellCode(code);
        sampleComponent.setCode(NewSampleComponentWithFixedMaterialTypeFactory.getCanonicalCode(code));
        return sampleComponent;
    }
}

