/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.client.model.ModalTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContactTableModel
extends ModalTableModel {
    private final Person[] contacts;
    private final String header;

    public ContactTableModel(Person[] contacts, String header, boolean prettyMode) {
        super(prettyMode);
        this.contacts = contacts;
        this.header = header;
    }

    @Override
    public final int getColumnCount() {
        return 4;
    }

    @Override
    public final String getHeader() {
        return this.header;
    }

    @Override
    public final int getRowCount() {
        return this.contacts.length;
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public final String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return FieldName.ACCOUNT.getName(this.prettyMode);
            }
            case 1: {
                return FieldName.FIRST_NAME.getName(this.prettyMode);
            }
            case 2: {
                return FieldName.LAST_NAME.getName(this.prettyMode);
            }
            case 3: {
                return FieldName.EMAIL.getName(this.prettyMode);
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        Person contact = this.contacts[rowIndex];
        switch (columnIndex) {
            case 0: {
                return contact.getUserId();
            }
            case 1: {
                return contact.getFirstName();
            }
            case 2: {
                return contact.getLastName();
            }
            case 3: {
                return contact.getEmail();
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }
}

