/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.lims.base.ListSet;
import ch.systemsx.cisd.lims.client.model.ModalTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListSetBasedTableModel
extends ModalTableModel {
    private final String header;
    private final ListSet listSet;
    private final List<String> columnUniqueCodes;
    private final int rowCount;

    public ListSetBasedTableModel(String header, ListSet listSet, boolean prettyMode) {
        super(prettyMode);
        this.listSet = listSet;
        this.header = header;
        this.columnUniqueCodes = new ArrayList<String>(listSet.getNamesOfNonEmptyColumns());
        Collections.sort(this.columnUniqueCodes, ListSetBasedTableModel.createComparatorByTitle(listSet, prettyMode));
        this.rowCount = listSet.getRowCount();
    }

    private static Comparator<String> createComparatorByTitle(final ListSet listSet, final boolean prettyMode) {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String l1 = ListSetBasedTableModel.getColumnLabel(o1, listSet, prettyMode);
                String l2 = ListSetBasedTableModel.getColumnLabel(o2, listSet, prettyMode);
                return l1.compareTo(l2);
            }
        };
    }

    @Override
    public final int getColumnCount() {
        return this.columnUniqueCodes.size();
    }

    @Override
    public final String getColumnName(int columnIndex) {
        this.assertColumnIndex(columnIndex);
        String uniqueCode = this.getColumnCode(columnIndex);
        return ListSetBasedTableModel.getColumnLabel(uniqueCode, this.listSet, this.prettyMode);
    }

    private static String getColumnLabel(String columnCode, ListSet listSet, boolean prettyMode) {
        if (prettyMode) {
            return listSet.getLabel(columnCode);
        }
        return columnCode;
    }

    private String getColumnCode(int columnIndex) {
        this.assertColumnIndex(columnIndex);
        return this.columnUniqueCodes.get(columnIndex);
    }

    @Override
    public final String getHeader() {
        return this.header;
    }

    @Override
    public final int getRowCount() {
        return this.rowCount;
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        return this.listSet.tryGetValueAt(this.getColumnCode(columnIndex), rowIndex);
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }
}

