/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.base.Vocabulary;
import ch.systemsx.cisd.lims.client.model.ModalTableModel;
import java.util.Arrays;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VocabularyTableModel
extends ModalTableModel {
    private final Vocabulary[] vocabularies;

    public VocabularyTableModel(Vocabulary[] vocabularies, boolean prettyMode) {
        super(prettyMode);
        this.vocabularies = vocabularies;
        Arrays.sort(vocabularies);
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return Person.class;
            }
            case 3: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public final int getColumnCount() {
        return 4;
    }

    @Override
    public final String getHeader() {
        return "Vocabularies";
    }

    @Override
    public final int getRowCount() {
        return this.vocabularies.length;
    }

    @Override
    public final String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return FieldName.CODE.getName(this.prettyMode);
            }
            case 1: {
                return FieldName.DESCRIPTION.getName(this.prettyMode);
            }
            case 2: {
                return FieldName.REGISTRATOR.getName(this.prettyMode);
            }
            case 3: {
                return FieldName.REGISTRATION_DATE.getName(this.prettyMode);
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        Vocabulary vocabulary = this.vocabularies[rowIndex];
        switch (columnIndex) {
            case 0: {
                return vocabulary.getCode();
            }
            case 1: {
                return vocabulary.getDescription();
            }
            case 2: {
                return vocabulary.getRegistrator();
            }
            case 3: {
                return vocabulary.getRegistrationDate();
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }
}

