/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.table;

import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.client.utilities.PersonDescriptor;
import ch.systemsx.cisd.lims.client.utilities.Utilities;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableRenderer {
    private static final Map<Class<?>, ITableRenderer<?>> renderers = TableRenderer.createRenderers();

    private TableRenderer() {
    }

    private static final Map<Class<?>, ITableRenderer<?>> createRenderers() {
        HashMap map = new HashMap();
        TableRenderer.addRenderer(map, Object.class, new ObjectRenderer());
        TableRenderer.addRenderer(map, Boolean.class, new BooleanRenderer());
        TableRenderer.addRenderer(map, Person.class, new PersonRenderer());
        TableRenderer.addRenderer(map, Date.class, new DateRenderer());
        return map;
    }

    private static final <T> void addRenderer(Map<Class<?>, ITableRenderer<?>> map, Class<T> clazz, ITableRenderer<T> renderer) {
        map.put(clazz, renderer);
    }

    public static final <T> String render(Class<T> clazz, Object valueOrNull) {
        assert (clazz != null) : "Unspecified class.";
        ITableRenderer<?> renderer = TableRenderer.getRendererForClass(clazz);
        if (valueOrNull == null) {
            return renderer.renderNull();
        }
        return renderer.render(valueOrNull);
    }

    public static final <T> String render(Class<T> clazz, Object valueOrNull, String defaultValue) {
        assert (clazz != null) : "Unspecified class.";
        ITableRenderer<?> renderer = TableRenderer.getRendererForClass(clazz);
        if (valueOrNull == null && defaultValue != null) {
            return defaultValue;
        }
        return renderer.render(valueOrNull);
    }

    private static final ITableRenderer<?> getRendererForClass(Class<?> clazz) {
        ITableRenderer<?> tableRenderer = renderers.get(clazz);
        Class<?> superclass = clazz.getSuperclass();
        if (tableRenderer == null && superclass != null) {
            return TableRenderer.getRendererForClass(superclass);
        }
        return tableRenderer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BooleanRenderer
    implements ITableRenderer<Boolean> {
        BooleanRenderer() {
        }

        @Override
        public final String renderNull() {
            return "?";
        }

        @Override
        public final String render(Boolean bool) {
            return BooleanUtils.toStringYesNo(bool);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DateRenderer
    implements ITableRenderer<Date> {
        DateRenderer() {
        }

        @Override
        public final String renderNull() {
            return "-";
        }

        @Override
        public final String render(Date object) {
            return Utilities.formatDate(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ITableRenderer<T> {
        public String renderNull();

        public String render(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ObjectRenderer
    implements ITableRenderer<Object> {
        ObjectRenderer() {
        }

        @Override
        public final String renderNull() {
            return "-";
        }

        @Override
        public final String render(Object object) {
            return object.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PersonRenderer
    implements ITableRenderer<Person> {
        PersonRenderer() {
        }

        @Override
        public final String renderNull() {
            return "-";
        }

        @Override
        public final String render(Person object) {
            return PersonDescriptor.getShortDescription(object);
        }
    }
}

