/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityPropertyProviderDAO;
import ch.systemsx.cisd.lims.server.dto.EntityPropertyValueDTO;
import ch.systemsx.cisd.lims.server.dto.IEntityPropertiesHolderDTO;
import ch.systemsx.cisd.lims.server.util.KeyExtractorFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EntityPropertyFiller {
    private EntityPropertyFiller() {
    }

    static final void fillPropertyFor(Iterable<? extends IEntityPropertiesHolderDTO> iterable, IEntityPropertyProviderDAO entityPropertyProvider) {
        assert (iterable != null) : "Given iterable can not be null.";
        assert (entityPropertyProvider != null) : "Given IEntityPropertyProvider can not be null.";
        List<IEntityPropertiesHolderDTO> allProperties = entityPropertyProvider.listAllEntityProperties();
        if (allProperties == null || allProperties.size() == 0) {
            return;
        }
        TableMap<Long, IEntityPropertiesHolderDTO> allPropertiesMap = new TableMap<Long, IEntityPropertiesHolderDTO>(allProperties, KeyExtractorFactory.getEntityPropertiesHolderKeyExtractor());
        for (IEntityPropertiesHolderDTO iEntityPropertiesHolderDTO : iterable) {
            IEntityPropertiesHolderDTO propertiesHolder = allPropertiesMap.tryGet(iEntityPropertiesHolderDTO.getEntityId());
            if (propertiesHolder == null) continue;
            iEntityPropertiesHolderDTO.setProperties(propertiesHolder.getProperties());
        }
    }

    static final void fillPropertyFor(IEntityPropertiesHolderDTO entity, IEntityPropertyProviderDAO entityPropertyProvider) {
        assert (entity != null) : "Unspecified entity.";
        assert (entityPropertyProvider != null) : "Given IEntityPropertyProvider can not be null.";
        entity.setProperties(entityPropertyProvider.listEntityProperties(entity.getEntityId()).toArray(EntityPropertyValueDTO.EMPTY_ARRAY));
    }
}

