/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SampleLayout {
    private Set<String> components = new HashSet<String>();
    private Set<String> overlappedComponents;

    SampleLayout(List<String> componentsOrNull) {
        if (componentsOrNull != null) {
            this.components.addAll(componentsOrNull);
        }
        this.overlappedComponents = new HashSet<String>();
    }

    private void addOverlapping(Set<String> newOverlapping) {
        this.overlappedComponents.addAll(newOverlapping);
    }

    void addComponents(Collection<String> newComponents) {
        HashSet<String> newOverlapped = new HashSet<String>(newComponents);
        newOverlapped.retainAll(this.components);
        this.components.addAll(newComponents);
        this.overlappedComponents.addAll(newOverlapped);
    }

    final void merge(SampleLayout layout) {
        this.addComponents(layout.components);
        this.addOverlapping(layout.overlappedComponents);
    }

    final Set<String> getComponents() {
        return this.components;
    }

    final Set<String> getOverlappedComponents() {
        return this.overlappedComponents;
    }
}

