/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.lims.server.dataaccess.IFileFormatTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dto.FileFormatTypeDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileFormatTypeDAO
extends AbstractTypeDAO<FileFormatTypeDTO>
implements IFileFormatTypeDAO {
    private static final ParameterizedRowMapper<FileFormatTypeDTO> FILE_FORMAT_TYPE_ROW_MAPPER = new ParameterizedRowMapper<FileFormatTypeDTO>(){

        public FileFormatTypeDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            FileFormatTypeDTO result = new FileFormatTypeDTO();
            result.setId(rs.getLong("id"));
            result.setCode(CodeConverter.tryToBusinessLayer(rs.getString("code")));
            result.setDescription(rs.getString("description"));
            return result;
        }
    };

    FileFormatTypeDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler) {
        super(dataSource, dtoValidatorStore, sequencerHandler);
    }

    @Override
    public final List<FileFormatTypeDTO> listFileFormatTypes() throws DataAccessException {
        return this.listTypes();
    }

    @Override
    public final FileFormatTypeDTO tryFindFileFormatTypeByCode(String code) throws DataAccessException {
        return (FileFormatTypeDTO)this.tryFindTypeByCode(code);
    }

    @Override
    protected final ParameterizedRowMapper<FileFormatTypeDTO> getRowMapper() {
        return FILE_FORMAT_TYPE_ROW_MAPPER;
    }

    @Override
    protected final String getTableName() {
        return "file_format_types";
    }
}

