/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.Constants;
import ch.systemsx.cisd.lims.webclient.client.application.ExperimentSampleCache;
import ch.systemsx.cisd.lims.webclient.client.application.FilePropertyGrid;
import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import ch.systemsx.cisd.lims.webclient.client.application.InputSamplesCellListener;
import ch.systemsx.cisd.lims.webclient.client.application.ModelBasedGrid;
import ch.systemsx.cisd.lims.webclient.client.application.PropertyValueRenderers;
import ch.systemsx.cisd.lims.webclient.client.application.ResultSamplesCellListener;
import ch.systemsx.cisd.lims.webclient.client.application.context.ViewContext;
import ch.systemsx.cisd.lims.webclient.client.application.model.InputSampleGridModel;
import ch.systemsx.cisd.lims.webclient.client.application.model.ProcessingInstructionGridModel;
import ch.systemsx.cisd.lims.webclient.client.application.model.ResultSampleGridModel;
import ch.systemsx.cisd.lims.webclient.client.application.ui.PropertyGrid;
import ch.systemsx.cisd.lims.webclient.client.application.utils.OrderedMap;
import ch.systemsx.cisd.lims.webclient.client.application.utils.WindowUtils;
import ch.systemsx.cisd.lims.webclient.client.dto.Experiment;
import ch.systemsx.cisd.lims.webclient.client.dto.ExperimentIdentifier;
import ch.systemsx.cisd.lims.webclient.client.dto.ExternalData;
import ch.systemsx.cisd.lims.webclient.client.dto.FileProperty;
import ch.systemsx.cisd.lims.webclient.client.dto.Invalidation;
import ch.systemsx.cisd.lims.webclient.client.dto.Procedure;
import ch.systemsx.cisd.lims.webclient.client.dto.ProcedureType;
import ch.systemsx.cisd.lims.webclient.client.dto.Sample;
import ch.systemsx.cisd.lims.webclient.client.dto.SimpleEntityProperty;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.grid.event.GridCellListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ExperimentContentPanel
extends VerticalPanel {
    private final Experiment experiment;
    private final Procedure dataAcquisitionProcedure;
    final ViewContext viewContext;

    public ExperimentContentPanel(ViewContext viewContext, Experiment experiment) {
        assert (experiment != null) : "Given experiment can not be null.";
        ExperimentContentPanel.completeProceduresWithSamples(experiment.getProcedures());
        this.experiment = experiment;
        this.dataAcquisitionProcedure = ExperimentContentPanel.tryGetDataAcquisitionProcedure(experiment);
        this.viewContext = viewContext;
        ExperimentSampleCache.initCache(experiment);
        this.setWidth("100%");
        this.setSpacing(5);
        this.add(this.createTitle());
        this.add(this.createGeneralPart());
        this.add(this.createDownloadPart());
        this.add(this.createExperimentPropertiesPart());
        this.add(this.createProcessingInstructionsPart());
        this.addProceduresPart();
    }

    private static final void completeProceduresWithSamples(Procedure[] procedures) {
        HashMap procDataMap = new HashMap();
        int procIx = 0;
        while (procIx < procedures.length) {
            Sample[] samples = procedures[procIx].getResultSamples();
            int sampleIx = 0;
            while (sampleIx < samples.length) {
                ExperimentContentPanel.putToProcedures(procDataMap, samples[sampleIx]);
                ++sampleIx;
            }
            ++procIx;
        }
        int i = 0;
        while (i < procedures.length) {
            Procedure procedure = procedures[i];
            String procTypeCode = ExperimentContentPanel.getTypeCode(procedure);
            List samplesList = (List)procDataMap.get(procTypeCode);
            if (samplesList != null) {
                Object[] samples = samplesList.toArray(new Sample[samplesList.size()]);
                Arrays.sort(samples);
                procedure.setResultSamples((Sample[])samples);
            }
            ++i;
        }
    }

    private static String getTypeCode(Procedure procedure) {
        return procedure.getProcedureType().getCode();
    }

    private static void putToProcedures(Map procDataMap, Sample sample) {
        Set procTypeCodes = ExperimentContentPanel.getProceduresFromData(sample);
        for (String procTypeCode : procTypeCodes) {
            ExperimentContentPanel.addSampleForProc(procDataMap, procTypeCode, sample);
        }
    }

    private static void addSampleForProc(Map procDataMap, String procTypeCode, Sample sample) {
        ArrayList<Sample> samplesList = (ArrayList<Sample>)procDataMap.get(procTypeCode);
        if (samplesList == null) {
            samplesList = new ArrayList<Sample>();
        }
        samplesList.add(sample);
        procDataMap.put(procTypeCode, samplesList);
    }

    private static Set getProceduresFromData(Sample sample) {
        HashSet<String> procTypeCodes = new HashSet<String>();
        ExperimentContentPanel.addProcedureTypeCodes(sample.getDerivedData(), procTypeCodes);
        ExperimentContentPanel.addProcedureTypeCodes(sample.getMeasurementData(), procTypeCodes);
        if (procTypeCodes.size() == 0) {
            procTypeCodes.add("DATA_ACQUISITION");
        }
        return procTypeCodes;
    }

    private static void addProcedureTypeCodes(ExternalData[] externalDatas, Set procTypeCodes) {
        int i = 0;
        while (i < externalDatas.length) {
            String procTypeCode = ExperimentContentPanel.getTypeCode(externalDatas[i].getProcedure());
            procTypeCodes.add(procTypeCode);
            ++i;
        }
    }

    private final void addProceduresPart() {
        Procedure[] procedures = this.experiment.getProcedures();
        int i = 0;
        while (i < procedures.length) {
            Procedure procedure = procedures[i];
            ProcedureType procedureType = procedure.getProcedureType();
            if (!this.isUnknownAndEmpty(procedure)) {
                Widget platesWidget;
                VerticalPanel verticalPanel = ExperimentContentPanel.createVerticalPanelPart();
                verticalPanel.add(ExperimentContentPanel.createPartTitle(this.viewContext.getMessageResources().getExperimentPanelProcedureTitle(procedureType.getDescription())));
                this.add((Widget)verticalPanel);
                Widget inputSamplesWidget = this.tryCreateInputSamplesPart(procedure);
                if (inputSamplesWidget != null) {
                    this.add(inputSamplesWidget);
                }
                if ((platesWidget = this.tryCreatePlatesPart(procedure)) != null) {
                    this.add(platesWidget);
                }
            }
            ++i;
        }
    }

    private boolean isUnknownAndEmpty(Procedure procedure) {
        boolean isUnknown = "UNKNOWN".compareTo(procedure.getProcedureType().getCode()) == 0;
        boolean noInputData = this.noDataAttached(procedure.getInputSamples());
        boolean noResultData = this.noDataAttached(procedure.getResultSamples());
        return isUnknown && noInputData && noResultData;
    }

    private boolean noDataAttached(Sample[] input) {
        int i = 0;
        while (i < input.length) {
            Sample sample = input[i];
            if (sample.getDerivedData().length != 0 || sample.getMeasurementData().length != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static final VerticalPanel createVerticalPanelPart() {
        VerticalPanel verticalPanel = new VerticalPanel();
        verticalPanel.setWidth("100%");
        verticalPanel.setSpacing(5);
        return verticalPanel;
    }

    private static final Procedure tryGetDataAcquisitionProcedure(Experiment experiment) {
        Procedure[] procedures = experiment.getProcedures();
        int i = 0;
        while (i < procedures.length) {
            Procedure procedure = procedures[i];
            if (ExperimentContentPanel.getTypeCode(procedure).equals("DATA_ACQUISITION")) {
                return procedure;
            }
            ++i;
        }
        throw new IllegalArgumentException("Given experiment '" + experiment + "' does not have any procedure of type '" + "DATA_ACQUISITION" + "'.");
    }

    private final Widget createDownloadPart() {
        VerticalPanel verticalPanel = ExperimentContentPanel.createVerticalPanelPart();
        verticalPanel.add(ExperimentContentPanel.createPartTitle(this.viewContext.getMessageResources().getExperimentDownloadPanelTitle()));
        if (this.dataAcquisitionProcedure.getResultSamples().length > 0) {
            verticalPanel.add(this.createMappingFileLink());
        }
        return verticalPanel;
    }

    private final Widget tryCreateInputSamplesPart(Procedure procedure) {
        VerticalPanel verticalPanel = ExperimentContentPanel.createVerticalPanelPart();
        verticalPanel.add(ExperimentContentPanel.createSubPartTitle(this.viewContext.getMessageResources().getExperimentPanelInputsTitle()));
        Object[] inputSamples = procedure.getInputSamples();
        int len = inputSamples.length;
        if (len == 0) {
            return null;
        }
        InputSampleGridModel gridModel = new InputSampleGridModel(this.viewContext.getMessageResources());
        ModelBasedGrid sampleGrid = new ModelBasedGrid(this.viewContext.getMessageResources(), inputSamples, gridModel, null);
        sampleGrid.addGridCellListener((GridCellListener)new InputSamplesCellListener(sampleGrid.getElement(), this.viewContext, this.experiment.getCode()));
        verticalPanel.add((Widget)sampleGrid);
        return verticalPanel;
    }

    private final Widget tryCreatePlatesPart(Procedure procedure) {
        VerticalPanel verticalPanel = ExperimentContentPanel.createVerticalPanelPart();
        verticalPanel.add(ExperimentContentPanel.createSubPartTitle(this.viewContext.getMessageResources().getExperimentPanelPlatesTitle()));
        Object[] results = procedure.getResultSamples();
        int len = results.length;
        if (len == 0) {
            return null;
        }
        ResultSampleGridModel gridModel = new ResultSampleGridModel(this.viewContext.getMessageResources(), procedure.getProcedureType());
        ModelBasedGrid sampleGrid = new ModelBasedGrid(this.viewContext.getMessageResources(), results, gridModel, null);
        sampleGrid.addGridCellListener((GridCellListener)new ResultSamplesCellListener(sampleGrid.getElement(), this.viewContext, this.experiment.getCode()));
        verticalPanel.add((Widget)sampleGrid);
        return verticalPanel;
    }

    private final Widget createMappingFileLink() {
        Element anchor = DOM.createAnchor();
        DOM.setElementAttribute((Element)anchor, (String)"href", (String)"javascript:return void;");
        DOM.setElementAttribute((Element)anchor, (String)"class", (String)"lims-a");
        DOM.setInnerText((Element)anchor, (String)this.viewContext.getMessageResources().getExperimentMappingFileLinkLabel());
        HTML html = new HTML(DOM.toString((Element)anchor));
        html.addClickListener(new ClickListener(){

            public final void onClick(Widget sender) {
                WindowUtils.openNewDependentWindow(ExperimentContentPanel.createURL(ExperimentContentPanel.this.experiment));
            }
        });
        return html;
    }

    static final String createURL(Experiment experiment) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Constants.EXPERIMENT_MAPPING_FILE_DOWNLOAD_SERVLET_NAME).append("?").append("project").append("=").append(experiment.getProject().getCode()).append("&").append("experiment").append("=").append(experiment.getCode());
        return buffer.toString();
    }

    private static final Widget createPartTitle(String text) {
        HTML html = new HTML(text);
        html.setStyleName("lims-heading");
        return html;
    }

    private static final Widget createSubPartTitle(String text) {
        HTML html = new HTML(text);
        html.setStyleName("lims-sub-heading");
        return html;
    }

    private final Widget createGeneralPart() {
        VerticalPanel verticalPanel = ExperimentContentPanel.createVerticalPanelPart();
        OrderedMap properties = new OrderedMap(false);
        IMessageResources messageResources = this.viewContext.getMessageResources();
        properties.put(messageResources.getExperimentTypeLabel(), this.experiment.getExperimentType());
        properties.put(messageResources.getExperimentStudyLabel(), this.experiment.getStudyObject());
        properties.put(messageResources.getRegistratorLabel(), this.experiment.getRegistrator());
        properties.put(messageResources.getRegistrationLabel(), this.experiment.getRegistrationDate());
        properties.put(messageResources.getProjectCodeLabel(), this.experiment.getProject());
        ExperimentContentPanel.putPropertiesDescription(this.experiment.getProperties(), properties);
        Invalidation invalidation = this.experiment.getInvalidation();
        if (invalidation != null) {
            properties.put(messageResources.getExperimentInvalidatorLabel(), invalidation.getRegistrator());
            properties.put(messageResources.getExperimentInvalidationDateLabel(), invalidation.getRegistrationDate());
            String reason = invalidation.getReason();
            if (reason == null) {
                reason = "Unknown";
            }
            properties.put(messageResources.getExperimentInvalidationReasonLabel(), reason);
        }
        verticalPanel.add(ExperimentContentPanel.createPartTitle(messageResources.getExperimentPanelGeneralTitle()));
        verticalPanel.add((Widget)this.createPropertyGrid(properties));
        return verticalPanel;
    }

    private static void putPropertiesDescription(SimpleEntityProperty[] entityProperties, OrderedMap properties) {
        int i = 0;
        while (i < entityProperties.length) {
            if (entityProperties[i] != null) {
                properties.put(entityProperties[i].getUserLabel(), entityProperties[i].tryGetUntypedValue());
            }
            ++i;
        }
    }

    private final Widget createProcessingInstructionsPart() {
        VerticalPanel panel = ExperimentContentPanel.createVerticalPanelPart();
        panel.add(ExperimentContentPanel.createPartTitle(this.viewContext.getMessageResources().getProcessingInstructionTitle()));
        Object[] processingInstructions = this.experiment.getProcessingInstructions();
        if (processingInstructions != null && processingInstructions.length > 0) {
            ProcessingInstructionGridModel gridModel = new ProcessingInstructionGridModel(this.viewContext.getMessageResources());
            panel.add((Widget)new ModelBasedGrid(this.viewContext.getMessageResources(), processingInstructions, gridModel, null));
        } else {
            HTML html = new HTML();
            html.setText(this.viewContext.getMessageResources().getEmpty("processing instruction", "experiment"));
            panel.add((Widget)html);
        }
        return panel;
    }

    private final PropertyGrid createPropertyGrid(OrderedMap properties) {
        IMessageResources messageResources = this.viewContext.getMessageResources();
        PropertyGrid propertyGrid = new PropertyGrid(messageResources, properties.size());
        propertyGrid.registerPropertyValueRenderer("ch.systemsx.cisd.lims.webclient.client.dto.Material", new PropertyValueRenderers.MaterialPropertyValueRenderer(messageResources));
        propertyGrid.registerPropertyValueRenderer("ch.systemsx.cisd.lims.webclient.client.dto.Person", new PropertyValueRenderers.PersonPropertyValueRenderer(messageResources));
        propertyGrid.registerPropertyValueRenderer("ch.systemsx.cisd.lims.webclient.client.dto.Project", new PropertyValueRenderers.ProjectPropertyValueRenderer(messageResources));
        propertyGrid.setProperties(properties);
        return propertyGrid;
    }

    private final Widget createExperimentPropertiesPart() {
        VerticalPanel verticalPanel = ExperimentContentPanel.createVerticalPanelPart();
        IMessageResources messageResources = this.viewContext.getMessageResources();
        verticalPanel.add(ExperimentContentPanel.createPartTitle(messageResources.getExperimentPanelPropertiesTitle()));
        FileProperty[] fileProperties = this.experiment.getFileProperties();
        int len = fileProperties.length;
        if (len == 0) {
            HTML html = new HTML();
            html.setText(messageResources.getEmpty("attachment", "experiment"));
            verticalPanel.add((Widget)html);
        } else {
            ExperimentIdentifier identifier = new ExperimentIdentifier(this.experiment.getProject().getCode(), this.experiment.getCode());
            verticalPanel.add((Widget)new FilePropertyGrid(messageResources, identifier, fileProperties, "150px"));
        }
        return verticalPanel;
    }

    private final Widget createTitle() {
        HorizontalPanel outerPanel = new HorizontalPanel();
        HorizontalPanel innerPanel = new HorizontalPanel();
        outerPanel.setWidth("100%");
        outerPanel.setHorizontalAlignment(HorizontalPanel.ALIGN_CENTER);
        outerPanel.add((Widget)innerPanel);
        IMessageResources messageResources = this.viewContext.getMessageResources();
        String title = messageResources.getExperimentPanelTitle(this.experiment.getCode());
        HTML html = new HTML(title);
        html.setStyleName("lims-font-big");
        innerPanel.add((Widget)html);
        if (this.experiment.getInvalidation() != null) {
            innerPanel.setSpacing(10);
            HTML invalid = new HTML(messageResources.getInvalidLabel());
            invalid.setStyleName("lims-font-big-red");
            innerPanel.add((Widget)invalid);
        }
        return outerPanel;
    }
}

