/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.AbstractAsyncCallbackWithLoadingMask;
import ch.systemsx.cisd.lims.webclient.client.application.PlateVisualisationDialog;
import ch.systemsx.cisd.lims.webclient.client.application.context.ViewContext;
import ch.systemsx.cisd.lims.webclient.client.application.utils.Log;
import ch.systemsx.cisd.lims.webclient.client.dto.PlateWells;
import com.google.gwt.user.client.Element;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.data.Record;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.Grid;
import com.gwtext.client.widgets.grid.event.GridCellListenerAdapter;

final class InputSamplesCellListener
extends GridCellListenerAdapter {
    private final String experimentCode;
    private final Element element;
    private final ViewContext viewContext;

    public InputSamplesCellListener(Element element, ViewContext viewContext, String experimentCode) {
        assert (element != null);
        assert (experimentCode != null);
        this.viewContext = viewContext;
        this.element = element;
        this.experimentCode = experimentCode;
    }

    private final void handleSampleClick(String expectedDataIndex, Grid grid, int rowIndex, int colIndex) {
        String sampleCode = this.tryGetClickedSampleCode(expectedDataIndex, grid, rowIndex, colIndex);
        if (sampleCode != null) {
            this.viewContext.getLimService().getPlateWells(sampleCode, false, new SampleInfoCallBack(sampleCode));
        }
    }

    private String tryGetClickedSampleCode(String expectedDataIndex, Grid grid, int rowIndex, int colIndex) {
        ColumnModel columnModel = grid.getColumnModel();
        String dataIndex = columnModel.getDataIndex(colIndex);
        if (dataIndex.equals(expectedDataIndex)) {
            Record record = grid.getStore().getAt(rowIndex);
            return record.getAsString(dataIndex);
        }
        return null;
    }

    public final void onCellClick(Grid grid, int rowIndex, int colIndex, EventObject e) {
        this.handleSampleClick("code", grid, rowIndex, colIndex);
    }

    private final class SampleInfoCallBack
    extends AbstractAsyncCallbackWithLoadingMask {
        private final long start;
        private final String sampleCode;

        SampleInfoCallBack(String sampleCode) {
            super(InputSamplesCellListener.this.viewContext);
            this.start = System.currentTimeMillis();
            this.sampleCode = sampleCode;
        }

        private final String createTitle() {
            return String.valueOf(InputSamplesCellListener.this.experimentCode) + " > " + InputSamplesCellListener.this.viewContext.getMessageResources().getExperimentPanelInputsTitle() + " > " + this.sampleCode;
        }

        protected final void afterSuccess(Object obj) {
            Log.logTimeTaken(this.start, "Getting visualisation of " + this.sampleCode);
            PlateWells result = (PlateWells)obj;
            PlateVisualisationDialog dialog = new PlateVisualisationDialog(result, this.createTitle(), InputSamplesCellListener.this.viewContext.getMessageResources());
            dialog.show(InputSamplesCellListener.this.element);
        }
    }
}

