/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application.ui;

import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.core.Ext;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.LayoutDialog;
import com.gwtext.client.widgets.LayoutDialogConfig;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.layout.ContentPanel;
import com.gwtext.client.widgets.layout.ContentPanelConfig;
import com.gwtext.client.widgets.layout.LayoutRegionConfig;

public abstract class AbstractLayoutDialog
extends LayoutDialog {
    private static final String DEFAULT_CLOSE_BUTTON_LABEL = "Close";
    protected static final int DEFAULT_WIDTH = 500;
    protected static final int DEFAULT_HEIGHT = 300;
    protected final IMessageResources messageResources;

    protected AbstractLayoutDialog(IMessageResources messageResources, String title) {
        this(messageResources, title, 500, 300);
    }

    protected AbstractLayoutDialog(IMessageResources messageResources, String title, int width, int height) {
        this(messageResources, title, width, height, false, true);
    }

    protected AbstractLayoutDialog(IMessageResources messageResources, String title, int width, int height, boolean modal, boolean closable) {
        super(AbstractLayoutDialog.createLayoutDialogConfig(title, width, height, modal, closable), AbstractLayoutDialog.createLayoutRegionConfig());
        this.messageResources = messageResources;
        if (closable) {
            this.createCloseButton();
        }
    }

    protected final void addContentPanel() {
        ContentPanel contentPanel = new ContentPanel(Ext.generateId(), AbstractLayoutDialog.createContentPanelConfig());
        contentPanel.add(this.createContentWidget());
        this.getLayout().add(contentPanel);
    }

    private static final ContentPanelConfig createContentPanelConfig() {
        ContentPanelConfig contentPanelConfig = new ContentPanelConfig();
        contentPanelConfig.setFitToFrame(true);
        contentPanelConfig.setAutoScroll(true);
        return contentPanelConfig;
    }

    private static final LayoutRegionConfig createLayoutRegionConfig() {
        LayoutRegionConfig config = new LayoutRegionConfig();
        return config;
    }

    protected static final LayoutDialogConfig createLayoutDialogConfig(String title, int width, int height, boolean modal, boolean closable) {
        LayoutDialogConfig config = new LayoutDialogConfig();
        config.setTitle(title);
        config.setModal(modal);
        config.setWidth(width);
        config.setHeight(height);
        config.setClosable(closable);
        config.setShadow(true);
        config.setFixedCenter(true);
        return config;
    }

    private final void createCloseButton() {
        String buttonLabel = this.messageResources == null ? DEFAULT_CLOSE_BUTTON_LABEL : this.messageResources.getDialogCloseButtonLabel();
        Button button = this.addButton(buttonLabel);
        button.addButtonListener((ButtonListener)new ButtonListenerAdapter(){

            public final void onClick(Button but, EventObject e) {
                AbstractLayoutDialog.this.hide();
            }
        });
    }

    protected abstract Widget createContentWidget();
}

