/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webservice;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.utilities.FileWatcherSynchronizer;
import ch.systemsx.cisd.lims.webservice.RoleBasedAccessController;
import java.io.File;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AccessControllerSynchronizer
extends FileWatcherSynchronizer {
    private final List<RoleBasedAccessController> accessControllers;

    public AccessControllerSynchronizer(List<RoleBasedAccessController> accessControllers) {
        this.accessControllers = accessControllers;
        this.addChangeListeners();
    }

    private static final ChangeListener createChangeListener(RoleBasedAccessController controller) {
        return controller.tryCreateChangeListener();
    }

    private static final File createFile(String userRolesResource) throws URISyntaxException {
        return new File(AccessControllerSynchronizer.class.getResource(userRolesResource).toURI());
    }

    private final void addChangeListeners() {
        try {
            for (RoleBasedAccessController controller : this.accessControllers) {
                ChangeListener changeListener = AccessControllerSynchronizer.createChangeListener(controller);
                assert (changeListener != null) : "Returned change listener can not be null.";
                this.addChangeListener(AccessControllerSynchronizer.createFile(controller.getUserRolesResource()), changeListener);
            }
        }
        catch (URISyntaxException e) {
            throw new ConfigurationFailureException("FileWatcherSynchronizer initialization failed.", e);
        }
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        this.accessControllers.clear();
    }
}

