/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webservice;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.server.IRemoteHostProvider;
import ch.systemsx.cisd.lims.base.LogMessageProvider;
import ch.systemsx.cisd.lims.base.server.IRequestContextProvider;
import ch.systemsx.cisd.lims.base.server.RequestContextProviderAdapter;
import ch.systemsx.cisd.lims.server.business.ISessionManager;
import ch.systemsx.cisd.lims.server.business.LoginLogManager;
import ch.systemsx.cisd.lims.server.business.ParameterChecker;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.dto.GroupDTO;
import ch.systemsx.cisd.lims.webservice.TokenGenerator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class DefaultSessionManager
implements ISessionManager {
    private static final TokenGenerator tokenGenerator = new TokenGenerator();
    private final Map<String, FullSession> sessions = new LinkedHashMap<String, FullSession>();
    private final IAuthenticationService authenticationService;
    private final IRemoteHostProvider remoteHostProvider;
    private final LoginLogManager loginLogManager;
    private final long sessionExpirationPeriodMillis;

    public DefaultSessionManager(IAuthenticationService authenticationService, IRequestContextProvider requestContextProvider, int sessionExpirationPeriodMinutes) {
        assert (authenticationService != null) : "IAuthenticationService implementation can not be null.";
        assert (requestContextProvider != null) : "IRequestContextProvider implementation can not be null.";
        assert (sessionExpirationPeriodMinutes >= 0);
        this.authenticationService = authenticationService;
        this.remoteHostProvider = new RequestContextProviderAdapter(requestContextProvider);
        this.loginLogManager = new LoginLogManager(this.getClass(), this.remoteHostProvider);
        this.sessionExpirationPeriodMillis = (long)sessionExpirationPeriodMinutes * 60000L;
        authenticationService.check();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String createAndStoreSession(String user, GroupDTO group, Principal principal, long now) {
        String sessionToken = String.valueOf(user) + "-" + tokenGenerator.getNewToken(now);
        Map<String, FullSession> map = this.sessions;
        synchronized (map) {
            Session session = new Session(user, sessionToken, principal, group, this.getRemoteHost(), now);
            FullSession createdSession = new FullSession(session, this.sessionExpirationPeriodMillis);
            this.sessions.put(user, createdSession);
        }
        return sessionToken;
    }

    private static final boolean isSessionUnavailable(FullSession session) {
        return session == null || DefaultSessionManager.doSessionExpiration(session);
    }

    private static final boolean doSessionExpiration(FullSession session) {
        return session != null && session.hasExpired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Session getSession(String sessionToken) throws UserFailureException {
        ParameterChecker.checkIfNotBlank(sessionToken, "sessionToken");
        Map<String, FullSession> map = this.sessions;
        synchronized (map) {
            String user = StringUtils.split(sessionToken, '-')[0];
            FullSession session = this.sessions.get(user);
            Logger authenticationLog = this.loginLogManager.getAuthenticationLog();
            if (session == null) {
                String msg = "Session token '" + sessionToken + "' is invalid: user is not logged in.";
                if (authenticationLog.isInfoEnabled()) {
                    authenticationLog.info(msg);
                }
                throw new InvalidSessionException(msg);
            }
            if (!sessionToken.equals(session.getSession().getSessionToken())) {
                String msg = "Session token '" + sessionToken + "' is invalid: wrong token.";
                if (authenticationLog.isInfoEnabled()) {
                    authenticationLog.info(msg);
                }
                throw new InvalidSessionException(msg);
            }
            if (DefaultSessionManager.doSessionExpiration(session)) {
                if (authenticationLog.isInfoEnabled()) {
                    authenticationLog.info(String.format("%sExpiring session '%s' for user '%s' after %d minutes of inactivity.", "LOGOUT: ", sessionToken, session.getSession().getUserName(), this.sessionExpirationPeriodMillis / 60000L));
                }
                DefaultSessionManager.logAuthUserBehaviour(this.createLogger(session.getSession().getUserName(), session.getSession().getGroupCode(), true).createSessionExpiredMessage(this.sessionExpirationPeriodMillis));
                this.sessions.remove(user);
            }
            if (DefaultSessionManager.isSessionUnavailable(session)) {
                throw new InvalidSessionException("Session no longer available. Please login again.");
            }
            session.touch();
            return session.getSession();
        }
    }

    public final String openSession(String user, String password, GroupDTO group) {
        String applicationToken;
        String code;
        block6: {
            ParameterChecker.checkIfNotBlank(user, "user");
            ParameterChecker.checkIfNotBlank(password, "password");
            code = group == null ? null : group.getCode();
            try {
                applicationToken = this.authenticationService.authenticateApplication();
                if (applicationToken != null) break block6;
                this.loginLogManager.getAuthenticationLog().error("User '" + user + "' failed to authenticate: application not authenticated.");
                return null;
            }
            catch (RuntimeException ex) {
                DefaultSessionManager.logAuthUserBehaviour(this.createLogger(user, code, false).login());
                this.loginLogManager.logCreateSessionFailure(user, ex);
                throw ex;
            }
        }
        String sessionToken = null;
        long now = System.currentTimeMillis();
        boolean isAuthenticated = this.authenticationService.authenticateUser(applicationToken, user, password);
        if (isAuthenticated) {
            try {
                Principal principal = this.authenticationService.getPrincipal(applicationToken, user);
                sessionToken = this.createAndStoreSession(user, group, principal, now);
            }
            catch (IllegalArgumentException ex) {
                throw new EnvironmentFailureException(ex.getMessage(), ex);
            }
        }
        this.loginLogManager.logAttemptCreateSession(user, isAuthenticated, sessionToken);
        DefaultSessionManager.logAuthUserBehaviour(this.createLogger(user, code, isAuthenticated).login());
        return sessionToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeSession(String sessionToken) {
        Map<String, FullSession> map = this.sessions;
        synchronized (map) {
            Session session = this.getSession(sessionToken);
            DefaultSessionManager.logAuthUserBehaviour(this.createLogger(session.getUserName(), session.getGroupCode(), true).logout(session.getSessionStart()));
            FullSession fullSession = this.sessions.remove(session.getUserName());
            this.loginLogManager.logAttemptCloseSession(sessionToken, fullSession.getSession());
        }
    }

    public String getRemoteHost() {
        return this.remoteHostProvider.getRemoteHost();
    }

    private LogMessageProvider createLogger(String username, String group, boolean invocationSuccessful) {
        return new LogMessageProvider(username, group, this.getRemoteHost(), invocationSuccessful);
    }

    private static void logAuthUserBehaviour(String message) {
        Logger logger = LogFactory.getLogger(LogCategory.AUTH);
        logger.info(message);
    }

    private static final class FullSession {
        private final Session session;
        private final long expirationPeriodMillis;
        private long lastActiveTime;

        FullSession(Session session, long expirationPeriodMillis) {
            assert (session != null) : "Undefined session";
            assert (expirationPeriodMillis >= 0L);
            this.session = session;
            this.expirationPeriodMillis = expirationPeriodMillis;
            this.touch();
        }

        public Session getSession() {
            return this.session;
        }

        void touch() {
            this.lastActiveTime = System.currentTimeMillis();
        }

        boolean hasExpired() {
            return System.currentTimeMillis() - this.lastActiveTime > this.expirationPeriodMillis;
        }
    }
}

