/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webservice;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.BaseExperiment;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ExternalData;
import ch.systemsx.cisd.lims.base.IETLLIMSService;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.base.server.IRequestContextProvider;
import ch.systemsx.cisd.lims.server.business.DomainModel;
import ch.systemsx.cisd.lims.server.business.IExperimentManager;
import ch.systemsx.cisd.lims.server.business.ISampleManager;
import ch.systemsx.cisd.lims.server.business.ISessionManager;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.webservice.AbstractLIMSService;
import ch.systemsx.cisd.lims.webservice.IAccessController;

public final class ETLLIMSService
extends AbstractLIMSService
implements IETLLIMSService {
    public ETLLIMSService(ISessionManager sessionManager, IRequestContextProvider requestContextProvider, IAccessController accessController, DomainModel domainModel, String groupCode) {
        super(sessionManager, requestContextProvider, accessController, domainModel, groupCode);
    }

    public BaseExperiment getBaseExperiment(String sessionToken, ExperimentIdentifier experimentIdentifierOrNull, String sampleCode) throws UserFailureException {
        boolean operationSuccessful = false;
        BaseExperiment baseExperimentOrNull = null;
        try {
            this.checkAccess(sessionToken);
            IExperimentManager experimentManager = this.domainModel.getExperimentManager();
            baseExperimentOrNull = experimentManager.tryGetBaseExperiment(this.getSession(sessionToken), experimentIdentifierOrNull, sampleCode);
            operationSuccessful = baseExperimentOrNull != null;
            BaseExperiment baseExperiment = baseExperimentOrNull;
            return baseExperiment;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).getBaseExperiment(experimentIdentifierOrNull, sampleCode));
        }
    }

    public SimpleEntityProperty[] tryToGetPropertiesOfTopSampleRegisteredFor(String sessionToken, String sampleCode) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            ISampleManager sampleManager = this.domainModel.getSampleManager();
            Session session = this.getSession(sessionToken);
            SimpleEntityProperty[] propertiesOrNull = sampleManager.tryToGetPropertiesOfTopSampleRegisteredFor(session, sampleCode);
            operationSuccessful = propertiesOrNull != null;
            SimpleEntityProperty[] simpleEntityPropertyArray = propertiesOrNull;
            return simpleEntityPropertyArray;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).tryGetPropertiesOfTopSampleRegisteredFor(sampleCode));
        }
    }

    public final void registerDataSet(String sessionToken, ExperimentIdentifier experimentIdentifierOrNull, String sampleCode, String procedureTypeCode, ExternalData data) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            ISampleManager dataSetManager = this.domainModel.getSampleManager();
            dataSetManager.registerDataSet(this.getSession(sessionToken), experimentIdentifierOrNull, sampleCode, procedureTypeCode, data);
            operationSuccessful = true;
        }
        finally {
            this.logTrackingUserBehaviour(this.createLogger(sessionToken, operationSuccessful).registerDataSet(experimentIdentifierOrNull, sampleCode, procedureTypeCode, data));
        }
    }

    public String createDataSetCode(String sessionToken) {
        boolean operationSuccessful = false;
        String dataSetCodeOrNull = null;
        try {
            this.checkAccess(sessionToken);
            dataSetCodeOrNull = this.domainModel.getSampleManager().createDataSetCode();
            operationSuccessful = true;
            String string = dataSetCodeOrNull;
            return string;
        }
        finally {
            this.logTrackingUserBehaviour(this.createLogger(sessionToken, operationSuccessful).createDataSetCode(dataSetCodeOrNull));
        }
    }
}

