/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.collections;

import ch.systemsx.cisd.common.collections.IQueuePersister;
import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordBasedQueuePersister<E>
implements IQueuePersister<E> {
    static final int DEFAULT_INITIAL_RECORD_SIZE = 32;
    private static final int HEADER_LENGTH = 12;
    private static final int RECORD_HEADER_LENGTH = 4;
    private static final int MAX_SLICK = 1000;
    private final Queue<E> queue;
    private final File queueFile;
    private final File newQueueFile;
    private final boolean autoSync;
    private int recordSize;
    private RandomAccessFile randomAccessFile;
    private int firstRecord;
    private int lastRecord;

    public static <E> List<E> list(Class<E> clazz, File queueFile) {
        File newQueueFile = new File(queueFile.getParentFile(), String.valueOf(queueFile.getName()) + ".new");
        ArrayList result = new ArrayList();
        RandomAccessFile randomAccessFile = null;
        try {
            try {
                randomAccessFile = !queueFile.exists() && newQueueFile.exists() ? new RandomAccessFile(newQueueFile, "r") : new RandomAccessFile(queueFile, "r");
                int firstRecord = randomAccessFile.readInt();
                int lastRecord = randomAccessFile.readInt();
                int recordSize = randomAccessFile.readInt();
                RecordBasedQueuePersister.load(randomAccessFile, result, firstRecord, lastRecord, recordSize);
            }
            catch (IOException iOException) {
                List list = Collections.emptyList();
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException2) {}
                }
                return list;
            }
        }
        catch (Throwable throwable) {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {}
        }
        return Collections.unmodifiableList(result);
    }

    public RecordBasedQueuePersister(Queue<E> queue, File queueFile) {
        this(queue, queueFile, 32, false);
    }

    public RecordBasedQueuePersister(Queue<E> queue, File queueFile, int initialRecordSize, boolean autoSync) {
        this.queue = queue;
        this.queueFile = queueFile;
        this.newQueueFile = new File(queueFile.getParentFile(), String.valueOf(queueFile.getName()) + ".new");
        this.autoSync = autoSync;
        if (!queueFile.exists() && this.newQueueFile.exists() && !this.newQueueFile.renameTo(queueFile)) {
            throw CheckedExceptionTunnel.wrapIfNecessary(new IOException("Cannot rename file '" + this.newQueueFile.getPath() + "' to '" + queueFile.getPath() + "'"));
        }
        try {
            this.randomAccessFile = new RandomAccessFile(queueFile, "rw");
            if (this.randomAccessFile.length() == 0L) {
                this.recordSize = initialRecordSize;
                RecordBasedQueuePersister.writeFullHeader(this.randomAccessFile, this.firstRecord, this.lastRecord, initialRecordSize);
            } else {
                this.firstRecord = this.randomAccessFile.readInt();
                this.lastRecord = this.randomAccessFile.readInt();
                this.recordSize = this.randomAccessFile.readInt();
            }
            RecordBasedQueuePersister.load(this.randomAccessFile, queue, this.firstRecord, this.lastRecord, this.recordSize);
            if (this.firstRecord > 0) {
                this.persist();
            }
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private byte[] toByteArray(E o) {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oo = new ObjectOutputStream(ba);
            oo.writeObject(o);
            oo.close();
            return ba.toByteArray();
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private static Object objFromByteArray(byte[] data) {
        ByteArrayInputStream bi = new ByteArrayInputStream(data);
        try {
            ObjectInputStream oi = new ObjectInputStream(bi);
            return oi.readObject();
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private void writeHeader() throws IOException {
        this.randomAccessFile.seek(0L);
        this.randomAccessFile.writeInt(this.firstRecord);
        this.randomAccessFile.writeInt(this.lastRecord);
    }

    private static void writeFullHeader(RandomAccessFile raf, int firstRecord, int lastRecord, int initialRecordSize) throws IOException {
        raf.seek(0L);
        raf.writeInt(firstRecord);
        raf.writeInt(lastRecord);
        raf.writeInt(initialRecordSize);
    }

    private static <E> void load(RandomAccessFile randomAccessFile, Collection<E> collection, int firstRecord, int lastRecord, int recordSize) {
        int pos = 12 + recordSize * firstRecord;
        int i = firstRecord;
        while (i < lastRecord) {
            try {
                randomAccessFile.seek(pos);
                pos += recordSize;
                int len = randomAccessFile.readInt();
                byte[] data = new byte[len];
                randomAccessFile.read(data, 0, len);
                RecordBasedQueuePersister.deserializeAndAdd(collection, data);
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
            ++i;
        }
    }

    private static <E> void deserializeAndAdd(Collection<E> collection, byte[] data) {
        collection.add(RecordBasedQueuePersister.objFromByteArray(data));
    }

    private static int getNewRecordSize(int oldRecordSize, int elementSize) {
        return oldRecordSize * (elementSize / oldRecordSize + 1);
    }

    @Override
    public void persist() {
        this.primPersist(this.recordSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primPersist(int newRecordSize) {
        File file = this.queueFile;
        synchronized (file) {
            try {
                this.randomAccessFile.close();
                RandomAccessFile newRandomAccessFile = new RandomAccessFile(this.newQueueFile, "rw");
                this.firstRecord = 0;
                this.lastRecord = this.queue.size();
                RecordBasedQueuePersister.writeFullHeader(newRandomAccessFile, this.firstRecord, this.lastRecord, newRecordSize);
                int pos = 12;
                for (Object elem : this.queue) {
                    newRandomAccessFile.seek(pos);
                    pos += newRecordSize;
                    byte[] data = this.toByteArray(elem);
                    int elementSize = data.length + 4;
                    if (elementSize > newRecordSize) {
                        this.primPersist(RecordBasedQueuePersister.getNewRecordSize(newRecordSize, elementSize));
                        return;
                    }
                    newRandomAccessFile.writeInt(data.length);
                    newRandomAccessFile.write(data);
                }
                this.randomAccessFile = newRandomAccessFile;
                this.recordSize = newRecordSize;
                if (!this.queueFile.delete()) {
                    throw new IOException("Cannot delete file '" + this.queueFile.getPath() + "'");
                }
                if (!this.newQueueFile.renameTo(this.queueFile)) {
                    throw new IOException("Cannot rename file '" + this.newQueueFile.getPath() + "' to '" + this.queueFile.getPath() + "'");
                }
                if (this.autoSync) {
                    this.sync();
                }
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToTail(E elem) {
        File file = this.queueFile;
        synchronized (file) {
            try {
                this.randomAccessFile.seek(12 + this.lastRecord * this.recordSize);
                byte[] data = this.toByteArray(elem);
                int elementSize = data.length + 4;
                if (elementSize > this.recordSize) {
                    this.primPersist(RecordBasedQueuePersister.getNewRecordSize(this.recordSize, elementSize));
                    return;
                }
                this.randomAccessFile.writeInt(data.length);
                this.randomAccessFile.write(data);
                ++this.lastRecord;
                this.writeHeader();
                if (this.autoSync) {
                    this.sync();
                }
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromHead(E elem) {
        File file = this.queueFile;
        synchronized (file) {
            try {
                if (this.firstRecord > 1000) {
                    this.persist();
                } else {
                    ++this.firstRecord;
                    this.writeHeader();
                    if (this.autoSync) {
                        this.sync();
                    }
                }
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    @Override
    public void check() throws IllegalStateException {
        try {
            if (!this.randomAccessFile.getFD().valid()) {
                throw new IllegalStateException("Cannot persist: file is closed.");
            }
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        File file = this.queueFile;
        synchronized (file) {
            try {
                this.randomAccessFile.close();
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    @Override
    public void sync() {
        try {
            this.randomAccessFile.getFD().sync();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }
}

