/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.concurrent;

import ch.systemsx.cisd.common.concurrent.ExecutionResult;
import ch.systemsx.cisd.common.concurrent.IActivitySensor;
import ch.systemsx.cisd.common.concurrent.ITerminableFuture;
import ch.systemsx.cisd.common.concurrent.TerminableCallable;
import ch.systemsx.cisd.common.concurrent.TerminableFuture;
import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.StopException;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrencyUtilities {
    public static final long NO_TIMEOUT = -1L;
    public static final long IMMEDIATE_TIMEOUT = 0L;

    public static <T> T tryGetResult(Future<T> future, long timeoutMillis) throws StopException {
        return ConcurrencyUtilities.tryGetResult(future, timeoutMillis, null, true);
    }

    public static <T> T tryGetResult(Future<T> future, long timeoutMillis, boolean stopOnInterrupt) throws StopException {
        return ConcurrencyUtilities.tryGetResult(future, timeoutMillis, null, stopOnInterrupt);
    }

    public static <T> T tryGetResult(Future<T> future, long timeoutMillis, ILogSettings logSettingsOrNull, boolean stopOnInterrupt) throws StopException {
        ExecutionResult<T> result = ConcurrencyUtilities.getResult(future, timeoutMillis, logSettingsOrNull);
        return ConcurrencyUtilities.tryDealWithResult(result, stopOnInterrupt);
    }

    public static <T> T tryDealWithResult(ExecutionResult<T> result) {
        return ConcurrencyUtilities.tryDealWithResult(result, true);
    }

    public static <T> T tryDealWithResult(ExecutionResult<T> result, boolean stopOnInterrupt) {
        switch (result.getStatus()) {
            case COMPLETE: {
                return result.tryGetResult();
            }
            case EXCEPTION: {
                Throwable cause = result.tryGetException();
                assert (cause != null);
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)cause);
            }
            case INTERRUPTED: {
                if (stopOnInterrupt) {
                    throw new StopException();
                }
                return null;
            }
        }
        return null;
    }

    public static <T> ExecutionResult<T> getResult(Future<T> future, long timeoutMillis) {
        return ConcurrencyUtilities.getResult(future, timeoutMillis, null);
    }

    public static <T> ExecutionResult<T> getResult(Future<T> future, long timeoutMillis, ILogSettings logSettingsOrNull) {
        return ConcurrencyUtilities.getResult(future, timeoutMillis, true, logSettingsOrNull);
    }

    public static <T> ExecutionResult<T> getResult(Future<T> future, long timeoutMillis, boolean cancelOnTimeout, ILogSettings logSettingsOrNull) {
        return ConcurrencyUtilities.getResult(future, timeoutMillis, cancelOnTimeout, logSettingsOrNull, null);
    }

    private static boolean isActive(IActivitySensor sensorOrNull, long timeoutMillis) {
        return sensorOrNull != null && sensorOrNull.hasActivityMoreRecentThan(timeoutMillis);
    }

    public static <T> ExecutionResult<T> getResult(Future<T> future, long timeoutMillis, boolean cancelOnTimeout, ILogSettings logSettingsOrNull, IActivitySensor sensorOrNull) {
        try {
            ExecutionResult<T> result = null;
            do {
                try {
                    result = ExecutionResult.create(future.get(ConcurrencyUtilities.transform(timeoutMillis), TimeUnit.MILLISECONDS));
                }
                catch (TimeoutException timeoutException) {}
            } while (result == null && ConcurrencyUtilities.isActive(sensorOrNull, timeoutMillis));
            if (result == null) {
                if (cancelOnTimeout) {
                    future.cancel(true);
                }
                if (logSettingsOrNull != null) {
                    logSettingsOrNull.getLogger().log(logSettingsOrNull.getLogLevelForError(), String.format("%s: timeout of %.2f s exceeded%s.", logSettingsOrNull.getOperationName(), Float.valueOf((float)timeoutMillis / 1000.0f), cancelOnTimeout ? ", cancelled" : ""));
                }
                return ExecutionResult.createTimedOut();
            }
            return result;
        }
        catch (InterruptedException interruptedException) {
            future.cancel(true);
            if (logSettingsOrNull != null) {
                logSettingsOrNull.getLogger().log(logSettingsOrNull.getLogLevelForError(), String.format("%s: interrupted.", logSettingsOrNull.getOperationName()));
            }
            return ExecutionResult.createInterrupted();
        }
        catch (StopException stopException) {
            future.cancel(true);
            if (logSettingsOrNull != null) {
                logSettingsOrNull.getLogger().log(logSettingsOrNull.getLogLevelForError(), String.format("%s: stopped.", logSettingsOrNull.getOperationName()));
            }
            return ExecutionResult.createInterrupted();
        }
        catch (ThreadDeath threadDeath) {
            future.cancel(true);
            if (logSettingsOrNull != null) {
                logSettingsOrNull.getLogger().log(logSettingsOrNull.getLogLevelForError(), String.format("%s: stopped.", logSettingsOrNull.getOperationName()));
            }
            return ExecutionResult.createInterrupted();
        }
        catch (CancellationException cancellationException) {
            if (logSettingsOrNull != null) {
                logSettingsOrNull.getLogger().log(logSettingsOrNull.getLogLevelForError(), String.format("%s: cancelled.", logSettingsOrNull.getOperationName()));
            }
            return ExecutionResult.createInterrupted();
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (logSettingsOrNull != null) {
                String message = cause == null || cause.getMessage() == null ? "<no message>" : cause.getMessage();
                String className = cause == null ? "<unknown class>" : cause.getClass().getSimpleName();
                logSettingsOrNull.getLogger().log(logSettingsOrNull.getLogLevelForError(), String.format("%s: exception: %s [%s].", logSettingsOrNull.getOperationName(), message, className));
            }
            return ExecutionResult.createExceptional(cause == null ? ex : cause);
        }
    }

    public static <V> ITerminableFuture<V> submit(ExecutorService executor, TerminableCallable<V> callable) {
        Future<V> future = executor.submit(callable);
        return new TerminableFuture<V>(future, callable);
    }

    public static <V> ITerminableFuture<V> submit(ExecutorService executor, TerminableCallable.ICallableCleaner<V> callableWithCleaner) {
        return ConcurrencyUtilities.submit(executor, TerminableCallable.create(callableWithCleaner));
    }

    public static <V> ITerminableFuture<V> submit(ExecutorService executor, TerminableCallable.ICallable<V> callable) {
        return ConcurrencyUtilities.submit(executor, TerminableCallable.create(callable));
    }

    public static <V> ITerminableFuture<V> submitAsStoppable(ExecutorService executor, Callable<V> stoppableCallable) {
        return ConcurrencyUtilities.submit(executor, TerminableCallable.createStoppable(stoppableCallable));
    }

    public static void sleep(long millis) throws StopException {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            throw new StopException(ex);
        }
    }

    public static void join(Thread thread) throws StopException {
        try {
            thread.join();
        }
        catch (InterruptedException ex) {
            throw new StopException(ex);
        }
    }

    public static void join(Thread thread, long millis) throws StopException {
        try {
            thread.join(millis);
        }
        catch (InterruptedException ex) {
            throw new StopException(ex);
        }
    }

    public static void wait(Object obj) throws StopException {
        try {
            obj.wait();
        }
        catch (InterruptedException ex) {
            throw new StopException(ex);
        }
    }

    public static void wait(Object obj, long millis) throws StopException {
        try {
            obj.wait(millis);
        }
        catch (InterruptedException ex) {
            throw new StopException(ex);
        }
    }

    private static long transform(long timeoutMillis) {
        return timeoutMillis < 0L ? Long.MAX_VALUE : timeoutMillis;
    }

    public static interface ILogSettings {
        public ISimpleLogger getLogger();

        public String getOperationName();

        public LogLevel getLogLevelForError();
    }
}

