/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.process;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.StopException;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallableExecutor {
    private final int maxRetryOnFailure;
    private final long millisToSleepOnFailure;

    public CallableExecutor() {
        this(11, 10000L);
    }

    public CallableExecutor(int maxRetryOnFailure, long millisToSleepOnFailure) {
        assert (millisToSleepOnFailure > -1L) : "Negative value";
        assert (maxRetryOnFailure > -1) : "Negative value";
        this.maxRetryOnFailure = maxRetryOnFailure;
        this.millisToSleepOnFailure = millisToSleepOnFailure;
    }

    public final <T> T executeCallable(Callable<T> callable) throws StopException {
        int counter = 0;
        T result = null;
        try {
            do {
                StopException.check();
                result = callable.call();
                if (counter <= 0 || this.millisToSleepOnFailure <= 0L) continue;
                Thread.sleep(this.millisToSleepOnFailure);
            } while (counter++ < this.maxRetryOnFailure && result == null);
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
        return result;
    }
}

