/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.datasetdownload;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import java.util.Properties;

class ConfigParameters {
    static final String SERVER_URL_KEY = "server-url";
    static final String PORT_KEY = "port";
    static final String STOREROOT_DIR_KEY = "storeroot-dir";
    static final String SESSION_TIMEOUT_KEY = "session-timeout";
    private static final String KEYSTORE = "keystore.";
    static final String KEYSTORE_PATH_KEY = "keystore.path";
    static final String KEYSTORE_PASSWORD_KEY = "keystore.password";
    static final String KEYSTORE_KEY_PASSWORD_KEY = "keystore.key-password";
    private final String storePath;
    private final int port;
    private final String serverURL;
    private final int sessionTimeout;
    private final String keystorePath;
    private final String keystorePassword;
    private final String keystoreKeyPassword;

    public ConfigParameters(Properties properties) {
        this.storePath = this.getProperty(properties, STOREROOT_DIR_KEY);
        this.port = this.getIntegerProperty(properties, PORT_KEY);
        this.serverURL = this.getProperty(properties, SERVER_URL_KEY);
        this.sessionTimeout = this.getIntegerProperty(properties, SESSION_TIMEOUT_KEY) * 60;
        this.keystorePath = this.getProperty(properties, KEYSTORE_PATH_KEY);
        this.keystorePassword = this.getProperty(properties, KEYSTORE_PASSWORD_KEY);
        this.keystoreKeyPassword = this.getProperty(properties, KEYSTORE_KEY_PASSWORD_KEY);
    }

    private int getIntegerProperty(Properties properties, String key) {
        String property = this.getProperty(properties, key);
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationFailureException("Configuration parameter '" + key + "' is not an integer number: " + property);
        }
    }

    private String getProperty(Properties properties, String key) {
        String property = properties.getProperty(key);
        if (property == null) {
            throw new ConfigurationFailureException("Configuration parameter '" + key + "' not specified.");
        }
        return property;
    }

    public final String getStorePath() {
        return this.storePath;
    }

    public final int getPort() {
        return this.port;
    }

    public final String getServerURL() {
        return this.serverURL;
    }

    public final int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public final String getKeystorePath() {
        return this.keystorePath;
    }

    public final String getKeystorePassword() {
        return this.keystorePassword;
    }

    public final String getKeystoreKeyPassword() {
        return this.keystoreKeyPassword;
    }
}

