/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds;

import ch.systemsx.cisd.bds.DataStructureFactory;
import ch.systemsx.cisd.bds.IDataStructure;
import ch.systemsx.cisd.bds.Version;
import ch.systemsx.cisd.bds.exception.DataStructureException;
import ch.systemsx.cisd.bds.storage.IStorage;
import ch.systemsx.cisd.bds.storage.filesystem.FileStorage;
import ch.systemsx.cisd.bds.storage.hdf5.HDF5Storage;
import java.io.File;

public class DataStructureLoader {
    private final File baseDir;

    public DataStructureLoader(File baseDir) {
        assert (baseDir != null) : "Unspecified base directory.";
        assert (baseDir.isDirectory()) : "Is not a directory : " + baseDir.getAbsolutePath();
        this.baseDir = baseDir;
    }

    public final IDataStructure load(String name) {
        IStorage storage = this.createStorage(name);
        storage.mount();
        Version version = Version.loadFrom(storage.getRoot());
        IDataStructure dataStructure = DataStructureFactory.createDataStructure(storage, version);
        dataStructure.open();
        return dataStructure;
    }

    private final IStorage createStorage(String name) {
        File file = new File(this.baseDir, name);
        if (!file.exists()) {
            throw new DataStructureException("No container name '" + name + "' exists in " + this.baseDir.getAbsolutePath());
        }
        if (file.isDirectory()) {
            return new FileStorage(file);
        }
        File hdf5File = new File(this.baseDir, String.valueOf(name) + ".hdf5");
        if (hdf5File.exists()) {
            return new HDF5Storage(hdf5File);
        }
        throw new DataStructureException("Couldn't found appropriate container named '" + name + "' in " + this.baseDir.getAbsolutePath());
    }
}

