/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds;

import ch.systemsx.cisd.bds.AbstractDataStructure;
import ch.systemsx.cisd.bds.DataSet;
import ch.systemsx.cisd.bds.ExperimentIdentifier;
import ch.systemsx.cisd.bds.ExperimentRegistrationTimestamp;
import ch.systemsx.cisd.bds.ExperimentRegistrator;
import ch.systemsx.cisd.bds.Format;
import ch.systemsx.cisd.bds.FormatParameter;
import ch.systemsx.cisd.bds.FormatParameters;
import ch.systemsx.cisd.bds.FormattedDataFactory;
import ch.systemsx.cisd.bds.IAnnotations;
import ch.systemsx.cisd.bds.IFormattedData;
import ch.systemsx.cisd.bds.Reference;
import ch.systemsx.cisd.bds.Sample;
import ch.systemsx.cisd.bds.UnknownFormatV1_0;
import ch.systemsx.cisd.bds.Utilities;
import ch.systemsx.cisd.bds.Version;
import ch.systemsx.cisd.bds.exception.DataStructureException;
import ch.systemsx.cisd.bds.handler.ChecksumHandler;
import ch.systemsx.cisd.bds.handler.MappingFileHandler;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.IStorage;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataStructureV1_0
extends AbstractDataStructure {
    public static final String DIR_METADATA = "metadata";
    public static final String DIR_ANNOTATIONS = "annotations";
    public static final String DIR_PARAMETERS = "parameters";
    public static final String DIR_DATA = "data";
    public static final String DIR_ORIGINAL = "original";
    public static final String DIR_STANDARD = "standard";
    private static final Version VERSION = new Version(1, 0);
    private final FormatParameters formatParameters = new FormatParameters();
    private MappingFileHandler mappingFileHandler;
    private Format format;
    private IAnnotations annotations;

    public DataStructureV1_0(IStorage storage) {
        super(storage);
    }

    private final void registerHandlers() {
        this.mappingFileHandler = new MappingFileHandler(this.getMetaDataDirectory(), this.getStandardData(), this.getOriginalData());
        this.registerHandler(this.mappingFileHandler);
        this.registerHandler(new ChecksumHandler(this.getMetaDataDirectory().makeDirectory("md5sum"), this.getOriginalData()));
    }

    public final IDirectory getOriginalData() {
        this.assertOpenOrCreated();
        return Utilities.getOrCreateSubDirectory(this.getDataDirectory(), DIR_ORIGINAL);
    }

    public final IDirectory getStandardData() {
        this.assertOpenOrCreated();
        return Utilities.getOrCreateSubDirectory(this.getDataDirectory(), DIR_STANDARD);
    }

    private final IDirectory getDataDirectory() {
        this.assertOpenOrCreated();
        return Utilities.getOrCreateSubDirectory(this.root, DIR_DATA);
    }

    private final IDirectory getMetaDataDirectory() {
        this.assertOpenOrCreated();
        return Utilities.getOrCreateSubDirectory(this.root, DIR_METADATA);
    }

    private final IDirectory getAnnotationsDirectory() {
        this.assertOpenOrCreated();
        return Utilities.getOrCreateSubDirectory(this.root, DIR_ANNOTATIONS);
    }

    private final IDirectory getParametersDirectory() {
        this.assertOpenOrCreated();
        return Utilities.getOrCreateSubDirectory(this.getMetaDataDirectory(), DIR_PARAMETERS);
    }

    public final IFormattedData getFormattedData() throws DataStructureException {
        this.assertOpenOrCreated();
        if (this.format == null) {
            throw new DataStructureException("Couldn't create formatted data because of unspecified format.");
        }
        return FormattedDataFactory.createFormattedData(this.getDataDirectory(), this.format, UnknownFormatV1_0.UNKNOWN_1_0, this.formatParameters);
    }

    public final void setFormat(Format format) {
        assert (format != null) : "Unspecified format.";
        this.assertOpenOrCreated();
        this.format = format;
        this.formatParameters.setFormatParameterFactory(format.getFormatParameterFactory());
    }

    public final void addFormatParameter(FormatParameter formatParameter) {
        assert (formatParameter != null) : "Unspecified format parameter.";
        this.formatParameters.addParameter(formatParameter);
    }

    public final void setAnnotations(IAnnotations annotations) {
        this.annotations = annotations;
    }

    public final ExperimentIdentifier getExperimentIdentifier() {
        this.assertOpenOrCreated();
        return ExperimentIdentifier.loadFrom(this.getMetaDataDirectory());
    }

    public final void setExperimentIdentifier(ExperimentIdentifier experimentIdentifier) {
        assert (experimentIdentifier != null) : "Unspecified experiment identifier";
        this.assertOpenOrCreated();
        experimentIdentifier.saveTo(this.getMetaDataDirectory());
    }

    public final ExperimentRegistrationTimestamp getExperimentRegistratorTimestamp() {
        this.assertOpenOrCreated();
        return ExperimentRegistrationTimestamp.loadFrom(this.getMetaDataDirectory());
    }

    public final void setExperimentRegistrationTimestamp(ExperimentRegistrationTimestamp date) {
        this.assertOpenOrCreated();
        date.saveTo(this.getMetaDataDirectory());
    }

    public final ExperimentRegistrator getExperimentRegistrator() {
        this.assertOpenOrCreated();
        return ExperimentRegistrator.loadFrom(this.getMetaDataDirectory());
    }

    public final void setExperimentRegistrator(ExperimentRegistrator registrator) {
        assert (registrator != null) : "Unspecified experiment registrator.";
        this.assertOpenOrCreated();
        registrator.saveTo(this.getMetaDataDirectory());
    }

    public final Sample getSample() {
        this.assertOpenOrCreated();
        return Sample.loadFrom(this.getMetaDataDirectory());
    }

    public final void setSample(Sample sample) {
        assert (sample != null) : "Unspecified measurement entity.";
        this.assertOpenOrCreated();
        sample.saveTo(this.getMetaDataDirectory());
    }

    public final void addReference(Reference reference) {
        this.assertOpenOrCreated();
        this.mappingFileHandler.addReference(reference);
    }

    public final Set<Reference> getStandardOriginalMapping() {
        return this.mappingFileHandler.getReferences();
    }

    public final void setDataSet(DataSet dataSet) {
        assert (dataSet != null) : "Unspecified data set.";
        this.assertOpenOrCreated();
        dataSet.saveTo(this.getMetaDataDirectory());
    }

    public final DataSet getDataSet() {
        this.assertOpenOrCreated();
        return DataSet.loadFrom(this.getMetaDataDirectory());
    }

    @Override
    protected void afterCreation() {
        this.registerHandlers();
    }

    @Override
    public final void assertValid() {
        super.assertValid();
        IDirectory metaDataDirectory = this.getMetaDataDirectory();
        if (metaDataDirectory.tryGetNode("format") == null && this.format == null) {
            throw new DataStructureException("Unspecified format.");
        }
        if (metaDataDirectory.tryGetNode("experiment_identifier") == null) {
            throw new DataStructureException("Unspecified experiment identifier.");
        }
        if (metaDataDirectory.tryGetNode("experiment_registration_timestamp") == null) {
            throw new DataStructureException("Unspecified experiment registration timestamp.");
        }
        if (metaDataDirectory.tryGetNode("experiment_registrator") == null) {
            throw new DataStructureException("Unspecified experiment registrator.");
        }
        if (metaDataDirectory.tryGetNode("sample") == null) {
            throw new DataStructureException("Unspecified sample.");
        }
        if (metaDataDirectory.tryGetNode("data_set") == null) {
            throw new DataStructureException("Unspecified data set.");
        }
        if (this.annotations != null) {
            this.annotations.assertValid(this.getFormattedData());
        }
    }

    @Override
    public final void performOpening() {
        this.registerHandlers();
        super.performOpening();
        this.setFormat(Format.loadFrom(this.getMetaDataDirectory()));
        this.formatParameters.loadFrom(this.getParametersDirectory());
    }

    @Override
    public final void performClosing() {
        super.performClosing();
        IDirectory metaDataDirectory = this.getMetaDataDirectory();
        this.formatParameters.saveTo(this.getParametersDirectory());
        if (metaDataDirectory.tryGetNode("format") == null && this.format != null) {
            this.format.saveTo(metaDataDirectory);
        }
        if (this.annotations != null) {
            this.annotations.saveTo(this.getAnnotationsDirectory());
        }
    }

    @Override
    public final Version getVersion() {
        return VERSION;
    }
}

