/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds;

import ch.systemsx.cisd.bds.Version;
import ch.systemsx.cisd.bds.exception.DataStructureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Factory<T> {
    private final Map<Version, Class<? extends T>> repository = new HashMap<Version, Class<? extends T>>();

    Factory() {
    }

    void register(Version version, Class<? extends T> clazz) {
        this.repository.put(version, clazz);
    }

    Class<? extends T> getClassFor(Version version) {
        Version v = version;
        Class<? extends T> clazz;
        while ((clazz = this.repository.get(v)) == null) {
            if (v.getMinor() == 0) {
                throw new DataStructureException("No class found for version " + version);
            }
            v = v.getPreviousMinorVersion();
        }
        return clazz;
    }

    T create(Class<?> argumentClass, Object argument, Version version) {
        Constructor<T> constructor;
        Class<T> clazz = this.getClassFor(version);
        try {
            constructor = clazz.getConstructor(argumentClass);
        }
        catch (Exception exception) {
            throw new EnvironmentFailureException(clazz + " has no constructor with argument of type " + argumentClass.getCanonicalName());
        }
        try {
            return constructor.newInstance(argument);
        }
        catch (InvocationTargetException ex) {
            throw new DataStructureException("Couldn't create instance of " + clazz + " for version " + version, ex.getCause());
        }
        catch (Exception ex) {
            throw new DataStructureException("Couldn't create instance of " + clazz + " for version " + version, ex);
        }
    }
}

