/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds;

import ch.systemsx.cisd.bds.FormatParameter;
import ch.systemsx.cisd.bds.IFormatParameterFactory;
import ch.systemsx.cisd.bds.IFormatParameters;
import ch.systemsx.cisd.bds.IStorable;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.INode;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FormatParameters
implements IFormatParameters,
IStorable {
    private final Map<String, FormatParameter> parameters = new LinkedHashMap<String, FormatParameter>();
    private IFormatParameterFactory formatParameterFactory = IFormatParameterFactory.DEFAULT_FORMAT_PARAMETER_FACTORY;

    FormatParameters() {
    }

    final void loadFrom(IDirectory directory) {
        this.parameters.clear();
        for (INode node : directory) {
            FormatParameter formatParameter = this.formatParameterFactory.createFormatParameter(node);
            if (formatParameter == null) continue;
            this.addParameter(formatParameter);
        }
    }

    @Override
    public final void saveTo(IDirectory directory) {
        for (FormatParameter parameter : this.parameters.values()) {
            Object value = parameter.getValue();
            assert (value != null) : "Parameter value can not be null.";
            if (value instanceof IStorable) {
                ((IStorable)value).saveTo(directory);
                continue;
            }
            directory.addKeyValuePair(parameter.getName(), value.toString());
        }
    }

    final void setFormatParameterFactory(IFormatParameterFactory formatParameterFactory) {
        this.formatParameterFactory = formatParameterFactory;
    }

    final void addParameter(FormatParameter parameter) {
        String parameterName = parameter.getName();
        if (this.containsParameter(parameterName)) {
            throw new IllegalArgumentException("There is already a parameter named '" + parameterName + "'.");
        }
        this.parameters.put(parameterName, parameter);
    }

    @Override
    public final Object getValue(String parameterName) {
        FormatParameter formatParameter = this.parameters.get(parameterName);
        if (formatParameter == null) {
            throw new IllegalArgumentException("Unknown parameter '" + parameterName + "'.");
        }
        return formatParameter.getValue();
    }

    @Override
    public final Iterator<FormatParameter> iterator() {
        return this.parameters.values().iterator();
    }

    @Override
    public final boolean containsParameter(String parameterName) {
        return this.parameters.containsKey(parameterName);
    }
}

