/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds;

import ch.systemsx.cisd.bds.Format;
import ch.systemsx.cisd.bds.UnknownFormatV1_0;
import ch.systemsx.cisd.bds.Version;
import ch.systemsx.cisd.bds.exception.DataStructureException;
import ch.systemsx.cisd.bds.hcs.HCSImageFormatV1_0;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormatStore {
    private static final Map<String, Format> formats = FormatStore.createFormats();

    private FormatStore() {
    }

    private static final Map<String, Format> createFormats() {
        HashMap<String, Format> map = new HashMap<String, Format>();
        map.put(FormatStore.getKey(UnknownFormatV1_0.UNKNOWN_1_0), UnknownFormatV1_0.UNKNOWN_1_0);
        map.put(FormatStore.getKey(HCSImageFormatV1_0.HCS_IMAGE_1_0), HCSImageFormatV1_0.HCS_IMAGE_1_0);
        return map;
    }

    private static final String getKey(Format format) {
        return FormatStore.getKey(format.getCode(), format.getVersion(), format.getVariant());
    }

    private static final String getKey(String formatCode, Version version, String variant) {
        String key = String.valueOf(formatCode) + version.toString();
        if (variant != null) {
            key = String.valueOf(key) + variant;
        }
        return key;
    }

    public static final Format getFormat(String formatCode, Version version, String formatVariant) throws DataStructureException {
        return formats.get(FormatStore.getKey(formatCode, version, formatVariant));
    }
}

