/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds;

import ch.systemsx.cisd.bds.Factory;
import ch.systemsx.cisd.bds.Format;
import ch.systemsx.cisd.bds.FormattedDataContext;
import ch.systemsx.cisd.bds.IFormatParameters;
import ch.systemsx.cisd.bds.IFormattedData;
import ch.systemsx.cisd.bds.NoFormattedData;
import ch.systemsx.cisd.bds.UnknownFormatV1_0;
import ch.systemsx.cisd.bds.exception.DataStructureException;
import ch.systemsx.cisd.bds.hcs.HCSImageFormatV1_0;
import ch.systemsx.cisd.bds.hcs.HCSImageFormattedData;
import ch.systemsx.cisd.bds.storage.IDirectory;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormattedDataFactory {
    private static final Map<String, Factory<IFormattedData>> factories = new HashMap<String, Factory<IFormattedData>>();

    static {
        FormattedDataFactory.register(UnknownFormatV1_0.UNKNOWN_1_0, NoFormattedData.class);
        FormattedDataFactory.register(HCSImageFormatV1_0.HCS_IMAGE_1_0, HCSImageFormattedData.class);
    }

    private FormattedDataFactory() {
    }

    private static final void register(Format format, Class<? extends IFormattedData> clazz) {
        String code = format.getCode();
        Factory<IFormattedData> factory = factories.get(code);
        if (factory == null) {
            factory = new Factory();
            factories.put(code, factory);
        }
        factory.register(format.getVersion(), clazz);
    }

    public static final IFormattedData createFormattedData(IDirectory dataDirectory, Format format, Format defaultFormatOrNull, IFormatParameters formatParameters) {
        Format supportedFormat = FormattedDataFactory.getSupportedFormat(format, defaultFormatOrNull);
        Factory<IFormattedData> factory = factories.get(supportedFormat.getCode());
        FormattedDataContext context = new FormattedDataContext(dataDirectory, supportedFormat, formatParameters);
        return factory.create(FormattedDataContext.class, context, format.getVersion());
    }

    private static final Format getSupportedFormat(Format format, Format defaultFormatOrNull) {
        assert (format != null) : "Unspecified format.";
        String code = format.getCode();
        assert (code != null) : "Unspecified format code.";
        assert (format.getVersion() != null) : "Unspecified version.";
        Factory<IFormattedData> factory = factories.get(code);
        if (factory == null) {
            if (defaultFormatOrNull != null) {
                return FormattedDataFactory.getSupportedFormat(defaultFormatOrNull, null);
            }
            throw new DataStructureException("Unknown format code '" + code + "'.");
        }
        return format;
    }
}

