/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds;

import ch.systemsx.cisd.bds.IStorable;
import ch.systemsx.cisd.bds.StringUtils;
import ch.systemsx.cisd.bds.Utilities;
import ch.systemsx.cisd.bds.storage.IDirectory;

public final class Sample
implements IStorable {
    static final String FOLDER = "sample";
    static final String TYPE_DESCRIPTION = "type_description";
    static final String TYPE_CODE = "type_code";
    static final String CODE = "code";
    private final String typeDescription;
    private final String typeCode;
    private final String code;

    static final Sample loadFrom(IDirectory directory) {
        assert (directory != null) : "Unspecified directory";
        IDirectory folder = Utilities.getSubDirectory(directory, FOLDER);
        String typeDescription = Utilities.getTrimmedString(folder, TYPE_DESCRIPTION);
        String code = Utilities.getTrimmedString(folder, CODE);
        String typeCode = Utilities.getTrimmedString(folder, TYPE_CODE);
        return new Sample(code, typeCode, typeDescription);
    }

    public Sample(String code, String typeCode, String typeDescription) {
        assert (!StringUtils.isEmpty(typeDescription)) : "Undefined sample type description.";
        this.typeDescription = typeDescription;
        assert (!StringUtils.isEmpty(code)) : "Undefined sample code.";
        this.code = code;
        assert (!StringUtils.isEmpty(typeCode)) : "Undefined sample type code.";
        this.typeCode = typeCode;
    }

    public final String getTypeDescription() {
        return this.typeDescription;
    }

    public final String getTypeCode() {
        return this.typeCode;
    }

    public final String getCode() {
        return this.code;
    }

    public final void saveTo(IDirectory directory) {
        IDirectory folder = directory.makeDirectory(FOLDER);
        folder.addKeyValuePair(TYPE_DESCRIPTION, this.typeDescription);
        folder.addKeyValuePair(CODE, this.code);
        folder.addKeyValuePair(TYPE_CODE, this.typeCode);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Sample)) {
            return false;
        }
        Sample that = (Sample)obj;
        return that.code.equals(this.code) && this.typeCode.equals(that.typeCode);
    }

    public final int hashCode() {
        int result = 17;
        result = 37 * result + this.code.hashCode();
        result = 37 * result + this.typeCode.hashCode();
        return result;
    }

    public final String toString() {
        return "[code:" + this.code + ",type:" + this.typeCode + ",typeDescription:" + this.typeDescription + "]";
    }
}

