/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds;

import ch.systemsx.cisd.bds.IStorable;
import ch.systemsx.cisd.bds.Utilities;
import ch.systemsx.cisd.bds.exception.DataStructureException;
import ch.systemsx.cisd.bds.storage.IDirectory;

public final class Version
implements IStorable {
    static final String VERSION = "version";
    static final String MAJOR = "major";
    static final String MINOR = "minor";
    private final int major;
    private final int minor;

    static Version loadFrom(IDirectory directory) {
        IDirectory versionFolder = Utilities.getSubDirectory(directory, VERSION);
        return new Version(Utilities.getNumber(versionFolder, MAJOR), Utilities.getNumber(versionFolder, MINOR));
    }

    public static final Version createVersionFromString(String value) {
        assert (value != null) : "Given value can not be null.";
        int index = value.indexOf(".");
        if (index > -1) {
            String strMajor = value.substring(0, index);
            String strMinor = value.substring(index + 1);
            try {
                return new Version(Integer.parseInt(strMajor), Integer.parseInt(strMinor));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    public Version(int major, int minor) {
        assert (major > 0) : "invalid major version number: " + major;
        this.major = major;
        assert (minor >= 0) : "invalid minor version number: " + minor;
        this.minor = minor;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public boolean isBackwardsCompatibleWith(Version version) {
        return version.major == this.major && version.minor <= this.minor;
    }

    public Version getPreviousMinorVersion() {
        if (this.minor == 0) {
            throw new DataStructureException("There is no previous minor version of " + this);
        }
        return new Version(this.major, this.minor - 1);
    }

    public final void saveTo(IDirectory directory) {
        IDirectory versionFolder = directory.makeDirectory(VERSION);
        versionFolder.addKeyValuePair(MAJOR, Integer.toString(this.major));
        versionFolder.addKeyValuePair(MINOR, Integer.toString(this.minor));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version version = (Version)obj;
        return version.major == this.major && version.minor == this.minor;
    }

    public int hashCode() {
        return this.major * 1000 + this.minor;
    }

    public String toString() {
        return "V" + this.major + "." + this.minor;
    }
}

