/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.hcs;

import ch.systemsx.cisd.bds.Format;
import ch.systemsx.cisd.bds.IAnnotations;
import ch.systemsx.cisd.bds.IFormattedData;
import ch.systemsx.cisd.bds.exception.DataStructureException;
import ch.systemsx.cisd.bds.hcs.Channel;
import ch.systemsx.cisd.bds.hcs.HCSImageFormatV1_0;
import ch.systemsx.cisd.bds.storage.IDirectory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HCSImageAnnotations
implements IAnnotations {
    private static final Set<Format> FORMATS = Collections.unmodifiableSet(new HashSet(Arrays.asList(HCSImageFormatV1_0.HCS_IMAGE_1_0)));
    private final Set<Channel> channels;

    public HCSImageAnnotations(Set<Channel> channels) {
        this.channels = channels;
    }

    public final Set<Channel> getChannels() {
        return Collections.unmodifiableSet(this.channels);
    }

    @Override
    public final void assertValid(IFormattedData formattedData) throws DataStructureException {
        int size;
        Format format = formattedData.getFormat();
        if (!FORMATS.contains(format)) {
            throw new DataStructureException("One of the following formats expected instead of '" + format + "': " + FORMATS);
        }
        Object value = formattedData.getFormatParameters().getValue("number_of_channels");
        int channelCount = (Integer)value;
        if (channelCount != (size = this.channels.size())) {
            throw new DataStructureException(String.format("Channel counts do not match (%d != %d).", channelCount, size));
        }
    }

    @Override
    public final void saveTo(IDirectory directory) {
        for (Channel channel : this.channels) {
            channel.saveTo(directory);
        }
    }
}

