/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.hcs;

import ch.systemsx.cisd.bds.AbstractFormattedData;
import ch.systemsx.cisd.bds.Format;
import ch.systemsx.cisd.bds.FormattedDataContext;
import ch.systemsx.cisd.bds.IFormatParameters;
import ch.systemsx.cisd.bds.Utilities;
import ch.systemsx.cisd.bds.exception.DataStructureException;
import ch.systemsx.cisd.bds.exception.StorageException;
import ch.systemsx.cisd.bds.hcs.Geometry;
import ch.systemsx.cisd.bds.hcs.HCSImageFormatV1_0;
import ch.systemsx.cisd.bds.hcs.IHCSImageFormattedData;
import ch.systemsx.cisd.bds.hcs.Location;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.INode;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class HCSImageFormattedData
extends AbstractFormattedData
implements IHCSImageFormattedData {
    public static final String COLUMN = "column";
    public static final String ROW = "row";
    private final DirectoryContentCache standardDataDirectoryCache;
    private final IDirectory originalDataDirectoryOrNull;
    private final boolean containsOriginalData;
    private final Geometry wellGeometry;
    private final Geometry plateGeometry;
    private final int channelCount;
    private File currentImageRootDirectory;
    private IDirectory currentImageRootDirectoryNode;
    private final HashSet<ImageFileKey> imageFilesStored = new HashSet();

    public HCSImageFormattedData(FormattedDataContext context) {
        super(context);
        this.containsOriginalData = HCSImageFormattedData.figureContainsOriginalData(this.getFormatParameters());
        this.originalDataDirectoryOrNull = this.containsOriginalData ? Utilities.getSubDirectory(this.dataDirectory, "original") : null;
        IDirectory standardDataDirectory = Utilities.getSubDirectory(this.dataDirectory, "standard");
        this.standardDataDirectoryCache = new DirectoryContentCache(standardDataDirectory, HCSImageFormattedData.createChannelDirNameProvider());
        this.wellGeometry = HCSImageFormattedData.figureWellGeometry(this.getFormatParameters());
        this.plateGeometry = HCSImageFormattedData.figurePlateGeometry(this.getFormatParameters());
        this.channelCount = HCSImageFormattedData.figureChannelCount(this.getFormatParameters());
    }

    private static int figureChannelCount(IFormatParameters params) {
        return (Integer)params.getValue("number_of_channels");
    }

    private static Geometry figurePlateGeometry(IFormatParameters params) {
        return (Geometry)params.getValue("plate_geometry");
    }

    private static Geometry figureWellGeometry(IFormatParameters params) {
        return (Geometry)params.getValue("well_geometry");
    }

    private static boolean figureContainsOriginalData(IFormatParameters params) {
        return ((Utilities.Boolean)((Object)params.getValue("contains_original_data"))).toBoolean();
    }

    public final boolean containsOriginalData() {
        return this.containsOriginalData;
    }

    public final Geometry getWellGeometry() {
        return this.wellGeometry;
    }

    public final Geometry getPlateGeometry() {
        return this.plateGeometry;
    }

    public final int getChannelCount() {
        return this.channelCount;
    }

    private static final void checkLocation(Geometry geometry, Location location) {
        if (!geometry.contains(location)) {
            throw new IllegalArgumentException(String.format("Given geometry '%s' does not contain location '%s'", geometry, location));
        }
    }

    private final void checkChannel(int channel) {
        if (channel < 1) {
            throw new IndexOutOfBoundsException(String.format("Channel index must start at 1 (given value is %d).", channel));
        }
        if (channel > this.channelCount) {
            throw new IndexOutOfBoundsException(String.format("Channel index %d exceeds the number of channels %d", channel, this.channelCount));
        }
    }

    static final String createWellFileName(Location wellLocation) {
        assert (wellLocation != null) : "Well location can not be null.";
        return ROW + wellLocation.getY() + "_" + COLUMN + wellLocation.getX() + ".tiff";
    }

    private static final String getPlateColumnDirName(int colNumber) {
        return COLUMN + colNumber;
    }

    private static final String getPlateRowDirName(int rowNumber) {
        return ROW + rowNumber;
    }

    private static final String getChannelName(int channel) {
        return "channel" + channel;
    }

    private void checkCoordinates(int channel, Location plateLocation, Location wellLocation) {
        this.checkChannel(channel);
        assert (plateLocation != null) : "Plate location can not be null.";
        assert (wellLocation != null) : "Well location can not be null.";
        HCSImageFormattedData.checkLocation(this.getPlateGeometry(), plateLocation);
        HCSImageFormattedData.checkLocation(this.getWellGeometry(), wellLocation);
    }

    private final IDirectory getImageRootDirectoryNode(File imageRootDirectory) {
        INode imageRootNode;
        assert (this.originalDataDirectoryOrNull != null) : "original data directrory not set";
        String imageRootDirName = imageRootDirectory.getName();
        if (this.originalDataDirectoryOrNull.tryGetNode(imageRootDirName) == null) {
            this.originalDataDirectoryOrNull.addFile(imageRootDirectory, null, true);
        }
        if ((imageRootNode = this.originalDataDirectoryOrNull.tryGetNode(imageRootDirName)) == null) {
            throw new DataStructureException(String.format("No image root directory named '%s' could be found in the original directory.", imageRootDirName));
        }
        assert (imageRootNode instanceof IDirectory) : "Image root node must be a directory.";
        return (IDirectory)imageRootNode;
    }

    public final INode tryGetStandardNodeAt(int channel, Location wellLocation, Location tileLocation) {
        this.checkCoordinates(channel, wellLocation, tileLocation);
        try {
            IDirectory plateColumnDir = this.getWellImagesParentDir(channel, wellLocation);
            return plateColumnDir.tryGetNode(HCSImageFormattedData.createWellFileName(tileLocation));
        }
        catch (DataStructureException dataStructureException) {
            return null;
        }
    }

    private IDirectory getWellImagesParentDir(int channel, Location wellLocation) {
        DirectoryContentCache channelDirCache = this.standardDataDirectoryCache.getSubdirectory(channel);
        DirectoryContentCache rowDirCache = channelDirCache.getSubdirectory(wellLocation.getY());
        DirectoryContentCache colDirCache = rowDirCache.getSubdirectory(wellLocation.getX());
        return colDirCache.getDirectory();
    }

    private final void updateImageRootDirectory(File imageRootDirectory) {
        assert (imageRootDirectory != null) : "Given image root directory can not be null.";
        if (imageRootDirectory == this.currentImageRootDirectory) {
            return;
        }
        if (!imageRootDirectory.equals(this.currentImageRootDirectory)) {
            this.currentImageRootDirectory = imageRootDirectory;
            this.currentImageRootDirectoryNode = this.getImageRootDirectoryNode(imageRootDirectory);
        }
    }

    private static INumberedDirNameProvider createChannelDirNameProvider() {
        return new INumberedDirNameProvider(){

            public String getName(int channel) {
                return HCSImageFormattedData.getChannelName(channel);
            }

            public INumberedDirNameProvider tryGetSubdirectoryProvider() {
                return HCSImageFormattedData.createRowDirNameProvider();
            }
        };
    }

    private static INumberedDirNameProvider createRowDirNameProvider() {
        return new INumberedDirNameProvider(){

            public String getName(int row) {
                return HCSImageFormattedData.getPlateRowDirName(row);
            }

            public INumberedDirNameProvider tryGetSubdirectoryProvider() {
                return HCSImageFormattedData.createColumnDirNameProvider();
            }
        };
    }

    private static INumberedDirNameProvider createColumnDirNameProvider() {
        return new INumberedDirNameProvider(){

            public String getName(int column) {
                return HCSImageFormattedData.getPlateColumnDirName(column);
            }

            public INumberedDirNameProvider tryGetSubdirectoryProvider() {
                return null;
            }
        };
    }

    public final IHCSImageFormattedData.NodePath addStandardNode(File imageRootDirectory, String imageRelativePath, int channel, Location wellLocation, Location tileLocation) throws DataStructureException {
        INode node;
        assert (imageRelativePath != null) : "Given image relative path can not be null.";
        this.check(channel, wellLocation, tileLocation);
        DirectoryContentCache channelDirCache = this.standardDataDirectoryCache.getSubdirectory(channel);
        DirectoryContentCache rowDirCache = channelDirCache.getSubdirectory(wellLocation.getY());
        DirectoryContentCache colDirCache = rowDirCache.getSubdirectory(wellLocation.getX());
        IDirectory plateColumnDir = colDirCache.getDirectory();
        String wellFileName = HCSImageFormattedData.createWellFileName(tileLocation);
        if (this.containsOriginalData) {
            this.updateImageRootDirectory(imageRootDirectory);
            INode imageNode = this.currentImageRootDirectoryNode.tryGetNode(imageRelativePath);
            if (imageNode == null) {
                throw new DataStructureException(String.format("No image node with path '%s' could be found in the 'original data' directory.", imageRelativePath));
            }
            node = plateColumnDir.tryAddLink(wellFileName, imageNode);
        } else {
            node = plateColumnDir.addFile(new File(imageRootDirectory, imageRelativePath), wellFileName, false);
        }
        if (node == null) {
            throw new StorageException(String.format("Original file name '%s' could not be added at channel %d, plate location '%s' and well location '%s'.", imageRelativePath, channel, wellLocation, tileLocation));
        }
        String standardNodePath = String.valueOf(channelDirCache.getDirectory().getName()) + '/' + rowDirCache.getDirectory().getName() + '/' + plateColumnDir.getName() + '/' + wellFileName;
        return new IHCSImageFormattedData.NodePath(node, standardNodePath);
    }

    private void check(int channel, Location wellLocation, Location tileLocation) {
        this.checkCoordinates(channel, wellLocation, tileLocation);
        ImageFileKey key = new ImageFileKey(channel, wellLocation, tileLocation);
        boolean alreadyStored = this.imageFilesStored.contains(key);
        if (!alreadyStored) {
            this.imageFilesStored.add(key);
        }
        if (alreadyStored) {
            throw new DataStructureException(String.format("A node already exists at channel %d, plate location '%s' and well location '%s'.", channel, wellLocation, tileLocation));
        }
    }

    public final Format getFormat() {
        return HCSImageFormatV1_0.HCS_IMAGE_1_0;
    }

    protected final void assertValidFormatAndFormatParameters() {
        super.assertValidFormatAndFormatParameters();
        IFormatParameters formatParameters = this.getFormatParameters();
        HashSet<String> notPresent = new HashSet<String>();
        for (String formatParameterName : this.format.getParameterNames()) {
            if (formatParameters.containsParameter(formatParameterName)) continue;
            notPresent.add(formatParameterName);
        }
        if (!notPresent.isEmpty()) {
            throw new DataStructureException(String.format("Following format parameters '%s' could not be found in the structure.", notPresent));
        }
    }

    private static class DirectoryContentCache {
        private final IDirectory currentDir;
        private final Map<Integer, DirectoryContentCache> subdirsCache;
        private final INumberedDirNameProvider nameProviderOrNull;

        public DirectoryContentCache(IDirectory currentDir, INumberedDirNameProvider nameProviderOrNull) {
            this.currentDir = currentDir;
            this.nameProviderOrNull = nameProviderOrNull;
            this.subdirsCache = new HashMap<Integer, DirectoryContentCache>();
        }

        public DirectoryContentCache getSubdirectory(int directoryNumber) {
            assert (this.nameProviderOrNull != null) : "this directory is no expected to have numbered subdirectories";
            DirectoryContentCache subdirCache = this.subdirsCache.get(directoryNumber);
            if (subdirCache == null) {
                String subdirName = this.nameProviderOrNull.getName(directoryNumber);
                IDirectory subdir = this.currentDir.makeDirectory(subdirName);
                INumberedDirNameProvider subdirNameProviderOrNull = this.nameProviderOrNull.tryGetSubdirectoryProvider();
                subdirCache = new DirectoryContentCache(subdir, subdirNameProviderOrNull);
                this.subdirsCache.put(directoryNumber, subdirCache);
            }
            return subdirCache;
        }

        public IDirectory getDirectory() {
            return this.currentDir;
        }
    }

    private static interface INumberedDirNameProvider {
        public String getName(int var1);

        public INumberedDirNameProvider tryGetSubdirectoryProvider();
    }

    private static class ImageFileKey {
        private final int channel;
        private final Location wellLocation;
        private final Location tileLocation;

        ImageFileKey(int channel, Location wellLocation, Location tileLocation) {
            assert (channel >= 0);
            assert (wellLocation != null);
            assert (tileLocation != null);
            this.channel = channel;
            this.wellLocation = wellLocation;
            this.tileLocation = tileLocation;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ImageFileKey)) {
                return false;
            }
            ImageFileKey that = (ImageFileKey)obj;
            return this.channel == that.channel && this.wellLocation.equals(that.wellLocation) && this.tileLocation.equals(that.tileLocation);
        }

        public int hashCode() {
            int hashCode = 17;
            hashCode = hashCode * 37 + this.channel;
            hashCode = hashCode * 37 + this.wellLocation.hashCode();
            hashCode = hashCode * 37 + this.tileLocation.hashCode();
            return hashCode;
        }
    }
}

