/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.hcs;

import ch.systemsx.cisd.bds.hcs.Geometry;
import ch.systemsx.cisd.common.geometry.ConversionUtils;
import ch.systemsx.cisd.common.geometry.Point;

public final class Location {
    static final String NOT_POSITIVE = "Given coordinate '%s' must be > 0 (%d <= 0).";
    private final int x;
    private final int y;

    public Location(int x, int y) {
        assert (x > 0) : String.format("Given coordinate '%s' must be > 0 (%d <= 0).", "x", x);
        this.x = x;
        assert (y > 0) : String.format("Given coordinate '%s' must be > 0 (%d <= 0).", "y", y);
        this.y = y;
    }

    public static final Location tryCreateLocationFromPosition(int position, Geometry geometry) {
        assert (geometry != null) : "Given geometry can not be null.";
        int columns = geometry.getColumns();
        int max = columns * geometry.getRows();
        if (position > 0 && position <= max) {
            int modulo = position % columns;
            int x = modulo == 0 ? columns : modulo;
            int y = (int)Math.ceil((float)position / (float)columns);
            return new Location(x, y);
        }
        return null;
    }

    public static final Location tryCreateLocationFromMatrixCoordinate(String coordinate) {
        try {
            Point point = ConversionUtils.parseSpreadsheetLocation(coordinate);
            return new Location(point.getY() + 1, point.getX() + 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location location = (Location)obj;
        return location.x == this.x && location.y == this.y;
    }

    public final int hashCode() {
        int hashCode = 17;
        hashCode = hashCode * 37 + this.x;
        hashCode = hashCode * 37 + this.y;
        return hashCode;
    }

    public final String toString() {
        return "[x=" + this.x + ",y=" + this.y + "]";
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

